// OpenGLss.h: interface for the COpenGLss class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OPENGLSS_H__085D1621_B2A8_11D1_8BA6_02608C4AC6B6__INCLUDED_)
#define AFX_OPENGLSS_H__085D1621_B2A8_11D1_8BA6_02608C4AC6B6__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <gl/gl.h>
#include <gl/glu.h>
#include "mylimits.h"
#include "piccel.h"
#include "afxmt.h"	//for ccriticalsection
#include "cimage.h"

typedef enum {ssIdle,ssRotateX, ssRotateY, ssRotateZ, ssZoomIn, ssColorIn,ssZoomOut} SSActions; 

class COpenGLss  
{
public:
	void Action();
	void Render();
	void DestroyGL();
	void Init(CWnd* cview);
	COpenGLss();
	virtual ~COpenGLss();

private:
	CCriticalSection g_cs;
	BOOL m_bBusy;
	SSActions m_Actions;
	int	m_ActionCounter;
	CPalette m_cPalette;
	CPalette *m_pOldPalette;
	unsigned char ComponentFromIndex(int i, UINT nbits, UINT shift);
	void CreateRGBPalette();
	BOOL bSetupPixelFormat();

	CImage*		m_cimage;
	CPicCel* m_celarray[MAX_CEL_COLUMN][MAX_CEL_ROW];
	int			m_particlesx,m_particlesy;

	BOOL		m_bGLRunning;
	RECT		m_oldRect;
	CClientDC	*m_pDC;


	GLfloat		m_fRadius,m_wAngleX,m_wAngleY,m_wAngleZ;
};

#endif // !defined(AFX_OPENGLSS_H__085D1621_B2A8_11D1_8BA6_02608C4AC6B6__INCLUDED_)
