// drawwnd.cpp : implementation file
//

#include "stdafx.h"
#include "Saver.h"
#include "drawwnd.h"
#include <afxmt.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CEvent g_eventOpenGLInit;
extern CEvent g_eventOpenGLStop;
extern CEvent g_eventOpenGLFinished;
LPCTSTR CDrawWnd::m_lpszClassName = NULL;


/////////////////////////////////////////////////////////////////////////////
// CDrawWnd

UINT OpenGLThreadProc(LPVOID pParam);
CDrawWnd::CDrawWnd(BOOL bAutoDelete)
{
	m_bFullscreen=FALSE;
	
	m_bOnce=TRUE;
	m_bAutoDelete = bAutoDelete;
	m_nPos = 0;
	m_nStep = 1;
	m_rgnLast.CreateRectRgn(0,0,0,0);

	m_nPicName = AfxGetApp()->GetProfileString("Config", "Picture", "test.gif");
	m_preview_image=new CImage(m_nPicName);	

	m_bPreview = AfxGetApp()->GetProfileInt("Config", "WindowPrev", FALSE);

	m_nStyle = AfxGetApp()->GetProfileInt("Config", "Style", PS_ENDCAP_ROUND|PS_JOIN_ROUND);

		AfxGetApp()->GetProfileInt("Config", "ColorRed", 255),
		AfxGetApp()->GetProfileInt("Config", "ColorGreen", 0),
		AfxGetApp()->GetProfileInt("Config", "ColorBlue",  0);
	
}

CDrawWnd::~CDrawWnd()
{
	delete m_preview_image;

	if (m_bFullscreen||m_bPreview) {
		g_eventOpenGLStop.SetEvent();
		::WaitForSingleObject(g_eventOpenGLFinished,INFINITE);	
		// wait a little to make sure other thread is finished
		// before we quit
		Sleep(1000);	
	

	};
	if (m_bFullscreen||m_bPreview)
		// restore display settings (to registry settings)
		ChangeDisplaySettings(NULL,0);
}


BEGIN_MESSAGE_MAP(CDrawWnd, CWnd)
	//{{AFX_MSG_MAP(CDrawWnd)
	ON_WM_TIMER()
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_CREATE()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()




void CDrawWnd::Draw(CDC& dc, int nWidth) 
{
}

void CDrawWnd::SetSpeed(int nSpeed)
{
	KillTimer(1);
	VERIFY(SetTimer(1, 50+500-nSpeed*5, NULL) != 0);
}

void CDrawWnd::SetResolution(int nRes)
{

}

void CDrawWnd::SetPenWidth(int nWidth)
{
	if (nWidth != m_nWidth)
	{
		CRect rect;
		m_nWidth = nWidth;
		Invalidate();
		UpdateWindow();
	}
}


/////////////////////////////////////////////////////////////////////////////
// CDrawWnd message handlers

void CDrawWnd::OnTimer(UINT nIDEvent) 
{
}


void CDrawWnd::OnPaint() 
{	
	if (m_bFullscreen || m_bPreview)
	if (m_bOnce)
	{
		// start worker thread to do the main opengl loop
		AfxBeginThread(OpenGLThreadProc,(CWnd*)this /*m_OpenGLss*/,THREAD_PRIORITY_NORMAL);		
		g_eventOpenGLInit.SetEvent();
		m_bOnce=FALSE;
	}

	
	CPaintDC dc(this); // device context for painting
	m_rgnLast.DeleteObject();
	m_rgnLast.CreateRectRgn(0,0,0,0);
	CBrush brush(RGB(0,0,0));
	CRect rect;
	GetClientRect(rect);
//	dc.FillRect(&rect, &brush);

if (!m_bFullscreen)
	if (m_preview_image) {

		CPalette *hOldPal = 0;
		if (m_preview_image->GetPalette())
		{
			hOldPal = dc.SelectPalette(m_preview_image->GetPalette(), TRUE);
			dc.RealizePalette();
			m_preview_image->Stretch(&dc,0,0,rect.right,rect.bottom);
		}
		
	}

	int nWidth = m_nWidth * rect.Width() + ::GetSystemMetrics(SM_CXSCREEN)/2;
	nWidth = nWidth/::GetSystemMetrics(SM_CXSCREEN);
	Draw(dc, nWidth);
	// Do not call CWnd::OnPaint() for painting messages


}

void CDrawWnd::OnSize(UINT nType, int cx, int cy) 
{
//	don't allow resizing in a screensaver
}

int CDrawWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	int nSpeed = AfxGetApp()->GetProfileInt("Config", "Speed", 1);
	if (nSpeed < 0)
		nSpeed = 0;	
	SetSpeed(nSpeed);

	return 0;
}

BOOL CDrawWnd::Create(DWORD dwExStyle, DWORD dwStyle, const RECT& rect, 
	CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
    // Register a class with no cursor
	if (m_lpszClassName == NULL)
	{
    	m_lpszClassName = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW,
			::LoadCursor(AfxGetResourceHandle(), 
			MAKEINTRESOURCE(IDC_NULLCURSOR)));
	}

	// TODO: Add your specialized code here and/or call the base class
	return CreateEx(dwExStyle, m_lpszClassName, _T(""), dwStyle, 
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 
		pParentWnd->GetSafeHwnd(), NULL, NULL );
}

void CDrawWnd::PostNcDestroy() 
{
	if (m_bAutoDelete)
		delete this;
}

void CDrawWnd::OnClose() 
{
	// TODO: Add your message handler code here and/or call default


	CWnd::OnClose();
}
