/***********************************************************************************
 * 4dmath.h             -       4 dimensional matrix math header
 *
 * Author:              Ron Bakker        (madrigal@gmx.net)
 * Description:         Starfield screensaver
 * Date:                04-03-1998
 ***********************************************************************************/

#ifndef __4DMATH_H__
#define __4DMATH_H__

#include "glidesystem.h"

#define DEG_TO_RAD        (.01745328f)

// matrix structure
typedef float           MATRIX4D[4][4];
typedef MATRIX4D         *LPMATRIX4D;

LPMATRIX4D Indentity_4D (void);
LPMATRIX4D RotationX_4D (float degrees);
LPMATRIX4D RotationY_4D (float degrees);
LPMATRIX4D RotationZ_4D (float degrees);
LPMATRIX4D Translation_4D (float x, float y, float z );
void SetViewTransformMatrix_4D (LPMATRIX4D matrix);
void ViewMatrixMult_4D (LPMATRIX4D matrix);
void TransformVerticesToView_4D (GrVertex3D *viewVerts, GrVertex3D *orgVerts, unsigned numberOfVerts);
void ProjectVerticesToViewport (GrVertex3D *projVerts, GrVertex3D *viewVerts, unsigned numberOfVerts);


#endif
