/***********************************************************************************
 * error.cpp            -  Printing error messages in a MessageBox ... pre-glideinit
 *
 * Author:              Ron Bakker        (madrigal@gmx.net)
 * Description:         Starfield screensaver
 * Date:                04-03-1998
 ***********************************************************************************/

#include <windows.h>
#include <stdlib.h>

/***********************************************************************************
 * WinError         - Message box with arguments .. used pre to InitGlide()
 ***********************************************************************************/
void WinError (char *fmt, ... )
{
    char buff[256];
    va_list args;
    
    va_start(args, fmt);
    wvsprintf(buff, fmt, args);
    va_end(args);
    
    lstrcat(buff, "\r\n");
    MessageBox(NULL, buff, "Save3Dfx - Fatal Error", MB_OK | MB_SYSTEMMODAL);
    exit (0);
}

