/***********************************************************************************
 * WndProc.cpp          -       Windows Event Processing
 *
 * Author:              Ron Bakker        (madrigal@gmx.net)
 * Description:         Starfield screensaver
 * Date:                04-03-1998
 ***********************************************************************************/

#include <windows.h>
#include <windowsx.h>           // windowsx has nice macro's .. use them to keep your code clean
#include <scrnsave.h>

#include "glidesystem.h"           // look for initialization
#include "fxdemo.h"             // look for end of excercise
#include "error.h"

static int mouseMoved = 0;

void Save3dfx_MouseMove (HWND hWnd, int x, int y, UINT keyFlags)
{
    /* In order to catch some WM_PAINTs and not to let the program accidently quit due
       to too many WM_MOUSEMOVEs we count to 4 */
    mouseMoved++;
    if (mouseMoved > 4)      
            EndOfExcercise = TRUE;      // We quit
}

void Save3dfx_Key (HWND hWnd, UINT ch, BOOL down, int cRepeat, UINT bla)
{
    /* Keypress means QUIT in a screensaver */
    EndOfExcercise = TRUE;
}

void Save3dfx_Destroy (HWND hWnd)
{
    /* If a WM_DESTROY is sent .. we may quit */
    EndOfExcercise = TRUE;
}

void Save3dfx_Paint (HWND hWnd)
{
    /* If we get here the window is ready to paint. */
}

LONG FAR PASCAL Save3dfxWndProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
    switch (message)    {
        /* Mouse Messages */
        HANDLE_MSG(hWnd, WM_MOUSEMOVE, Save3dfx_MouseMove);
        /* KeyStrokes */
        HANDLE_MSG(hWnd, WM_KEYUP,     Save3dfx_Key);
        HANDLE_MSG(hWnd, WM_KEYDOWN,   Save3dfx_Key);
        /* Window Messages */
        HANDLE_MSG(hWnd, WM_DESTROY,   Save3dfx_Destroy);
        /* Other Messages */
        HANDLE_MSG(hWnd, WM_PAINT,     Save3dfx_Paint);
        /* My Watcom C/C++ 11.0 compiler did not like the windowsx macro for WM_SETCURSOR */
        case WM_SETCURSOR :  SetCursor (NULL);
                              return TRUE;
        case WM_SYSCOMMAND : return FALSE;
        default:
           return DefWindowProc(hWnd, message, wParam, lParam);
    }
}

