/*
** Copyright (c) 1995, 3Dfx Interactive, Inc.
** All Rights Reserved.
**
** This is UNPUBLISHED PROPRIETARY SOURCE CODE of 3Dfx Interactive, Inc.;
** the contents of this file may not be disclosed to third parties, copied or
** duplicated in any form, in whole or in part, without the prior written
** permission of 3Dfx Interactive, Inc.
**
** RESTRICTED RIGHTS LEGEND:
** Use, duplication or disclosure by the Government is subject to restrictions
** as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
** and Computer Software clause at DFARS 252.227-7013, and/or in similar or
** successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
** rights reserved under the Copyright Laws of the United States.
**
*/
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "glib.h"

#define WREFWIDTH 640.f
#define WREFHEIGHT 480.f

#define WINSCALEX(x) ((x/WREFWIDTH) * wWidth)
#define WINSCALEY(y) ((y/WREFHEIGHT) * wHeight)  

GrState oldState;

GrHwConfiguration hwconfig;

#ifdef __DJGPP__
#include <crt0.h>
int crt0_startup_flags = _CRT0_FLAG_NONMOVE_SBRK;
#endif



void AATriangle(float x1, float y1, float z1, float r1, float g1, float b1, float a1,
float x2, float y2, float z2, float r2, float g2, float b2, float a2,
float x3, float y3, float z3, float r3, float g3, float b3, float a3
){
 GrVertex vtx1, vtx2, vtx3;

 vtx1.x = x1;
 vtx1.y = y1;
 vtx1.ooz = z1;
 vtx1.r = r1;
 vtx1.g = g1;
 vtx1.b = b1;
 vtx1.a = a1;

 vtx2.x = x2;
 vtx2.y = y2;
 vtx2.ooz = z2;
 vtx2.r = r2;
 vtx2.g = g2;
 vtx2.b = b2;
 vtx2.a = a2;

 
 vtx3.x = x3;
 vtx3.y = y3;
 vtx3.ooz = z3;
 vtx3.r = r3;
 vtx3.g = g3;
 vtx3.b = b3;
 vtx3.a = a3;
 
 grAADrawTriangle( &vtx1, &vtx2, &vtx3, FXTRUE, FXTRUE, FXTRUE );

}


void initMethodes(void){

 guColorCombineFunction( GR_COLORCOMBINE_ITRGB );

 /* grColorCombine( GR_COMBINE_FUNCTION_LOCAL,
                    GR_COMBINE_FACTOR_NONE,
                    GR_COMBINE_LOCAL_CONSTANT,
                    GR_COMBINE_OTHER_NONE,
                    FXFALSE );*/

 grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
				GR_COMBINE_FACTOR_NONE,
				GR_COMBINE_LOCAL_ITERATED,
				GR_COMBINE_OTHER_NONE,
				FXFALSE); 

 grAlphaCombine( GR_COMBINE_FUNCTION_SCALE_OTHER,
                 GR_COMBINE_FACTOR_ONE,
		 GR_COMBINE_LOCAL_CONSTANT,
		 GR_COMBINE_OTHER_ITERATED, FXFALSE );


 grAlphaBlendFunction( GR_BLEND_SRC_ALPHA,
		       GR_BLEND_ONE_MINUS_SRC_ALPHA,
                       GR_BLEND_ZERO, GR_BLEND_ZERO );

}




void init3DFX(void ){
  float
    wWidth, wHeight;
  GrScreenResolution_t
    screenRes;

  wWidth = 640.f;
  wHeight = 480.f;
  screenRes = GR_RESOLUTION_640x480;

  grGlideInit();

  if ( !grSstQueryHardware( &hwconfig ) )
  {
    fprintf( stderr, "main: grSstQueryHardware failed!\n" );
    grGlideShutdown();
    exit( -1 );
  }

  /*
  ** Select SST 0
  */
  grSstSelect( 0 );

  /*
  ** Open up the hardware
  */
  if ( !grSstWinOpen( NULL,
					screenRes,
                   GR_REFRESH_60Hz,
                   GR_COLORFORMAT_ABGR,
                   GR_ORIGIN_LOWER_LEFT,
                   GR_SMOOTHING_ENABLE,
                   2 ) )
  {
    fprintf( stderr, "main: grSstOpen failed!\n" );
    grGlideShutdown();
    exit( -1 );
  }
  grClipWindow(0,0,639,479);
  // tlConSet (0.0f, 0.0f, 1.0f, 1.0f, 60, 30, 0xffffff);

}

void exit3DFX(void){
  grGlideShutdown();
}




texture loadtexture(char *nom){
  texture tmp;

  tmp = (texture)(malloc(sizeof(struct stexture)));

  if ( gu3dfGetInfo( nom, &tmp->info ) )  {
    tmp->info.data = malloc( tmp->info.mem_required );
    
    if ( tmp->info.data == 0 ) {
       fprintf( stderr, "out of memory for texture file %s\n", nom );
       grGlideShutdown();
       exit( -1 );
    }




  if ( !gu3dfLoad( nom, & (tmp->info) ) ) {
    fprintf( stderr, "could not load texture file %s\n", nom );
    grGlideShutdown();
    exit( -1 );
  }

  tmp->tex = guTexAllocateMemory( 0, GR_MIPMAPLEVELMASK_BOTH,
                                  tmp->info.header.width, tmp->info.header.height,
                                  tmp->info.header.format,
                                  GR_MIPMAP_NEAREST,
                                  tmp->info.header.small_lod, tmp->info.header.large_lod,
                                  tmp->info.header.aspect_ratio,
                                  GR_TEXTURECLAMP_WRAP, GR_TEXTURECLAMP_WRAP,
                                  GR_TEXTUREFILTER_BILINEAR, GR_TEXTUREFILTER_BILINEAR,
                                  0.0F,
                                  FXFALSE );

  if ( tmp->tex == GR_NULL_MIPMAP_HANDLE ) {
       fprintf( stderr, "could not allocate memory for texture file %s\n", nom );
       grGlideShutdown();
       exit( -1 );
     }

  guTexDownloadMipMap( tmp->tex, tmp->info.data, &tmp->info.table.nccTable );

  }
  
 else {
   fprintf( stderr, "could not get info on %s\n", nom );
   grGlideShutdown();
   exit( -1 );
 }

  return(tmp);

}



void flare(float x, float y, float tay, float r, float g, float b, float alpha){
  GrVertex texVerts[4]; 
  GrState oldState;


  tay = tay / 2;

  texVerts[0].x = x -tay;
  texVerts[0].y = y - tay;
  texVerts[0].r = r;
  texVerts[0].g = g;
  texVerts[0].b = b;
  texVerts[0].a = alpha;
  texVerts[0].oow = 1.f;
  texVerts[0].tmuvtx[0].sow = 0.f * texVerts[0].oow;
  texVerts[0].tmuvtx[0].tow = 255.f * texVerts[0].oow;

  texVerts[1].x = x+tay;
  texVerts[1].y = y-tay;
  texVerts[1].r = r;
  texVerts[1].g = g;
  texVerts[1].b = b;
  texVerts[1].a = alpha;
  texVerts[1].oow = 1.f;
  texVerts[1].tmuvtx[0].sow = 255.f * texVerts[1].oow;
  texVerts[1].tmuvtx[0].tow = 255.f * texVerts[1].oow;

  texVerts[2].x = x+tay;
  texVerts[2].y = y+tay;
  texVerts[2].r = r;
  texVerts[2].g = g;
  texVerts[2].b = b;
  texVerts[2].a = alpha;
  texVerts[2].oow = 1.f;
  texVerts[2].tmuvtx[0].sow = 255.f * texVerts[2].oow;
  texVerts[2].tmuvtx[0].tow = 0.f * texVerts[2].oow;
  
  texVerts[3].x = x-tay;
  texVerts[3].y = y+tay;
  texVerts[3].r = r;
  texVerts[3].g = g;
  texVerts[3].b = b;
  texVerts[3].a = alpha;
  texVerts[3].oow = 1.f;
  texVerts[3].tmuvtx[0].sow = 0.f * texVerts[3].oow;
  texVerts[3].tmuvtx[0].tow = 0.f * texVerts[3].oow;
  

	        
	grDrawTriangle(&texVerts[0], &texVerts[1], &texVerts[2]);
	grDrawTriangle(&texVerts[2], &texVerts[3], &texVerts[0]);
        

}


void initflare(texture t){


   grAlphaBlendFunction( GR_BLEND_ONE, GR_BLEND_ONE,
			                               GR_BLEND_ONE, GR_BLEND_ZERO);

    guColorCombineFunction( GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB); 

   guTexSource(t->tex);
	
   guAlphaSource( GR_ALPHASOURCE_ITERATED_ALPHA);

   grTexCombineFunction(GR_TMU0, GR_TEXTURECOMBINE_ADD );

}

void
sauveEtat3DFX(void){
 grGlideGetState(&oldState);
}

void restoreEtat(void){
 grGlideSetState(&oldState);
}



void flaresub(float x, float y, texture t, float tay, float r, float g, float b, float alpha){
  GrVertex texVerts[4]; 
  GrState oldState;


  tay = tay / 2;

  texVerts[0].x = x -tay;
  texVerts[0].y = y - tay;
  texVerts[0].r = r;
  texVerts[0].g = g;
  texVerts[0].b = b;
  texVerts[0].a = alpha;
  texVerts[0].oow = 1.f;
  texVerts[0].tmuvtx[0].sow = 0.f * texVerts[0].oow;
  texVerts[0].tmuvtx[0].tow = 255.f * texVerts[0].oow;

  texVerts[1].x = x+tay;
  texVerts[1].y = y-tay;
  texVerts[1].r = r;
  texVerts[1].g = g;
  texVerts[1].b = b;
  texVerts[1].a = alpha;
  texVerts[1].oow = 1.f;
  texVerts[1].tmuvtx[0].sow = 255.f * texVerts[1].oow;
  texVerts[1].tmuvtx[0].tow = 255.f * texVerts[1].oow;

  texVerts[2].x = x+tay;
  texVerts[2].y = y+tay;
  texVerts[2].r = r;
  texVerts[2].g = g;
  texVerts[2].b = b;
  texVerts[2].a = alpha;
  texVerts[2].oow = 1.f;
  texVerts[2].tmuvtx[0].sow = 255.f * texVerts[2].oow;
  texVerts[2].tmuvtx[0].tow = 0.f * texVerts[2].oow;
  
  texVerts[3].x = x-tay;
  texVerts[3].y = y+tay;
  texVerts[3].r = r;
  texVerts[3].g = g;
  texVerts[3].b = b;
  texVerts[3].a = alpha;
  texVerts[3].oow = 1.f;
  texVerts[3].tmuvtx[0].sow = 0.f * texVerts[3].oow;
  texVerts[3].tmuvtx[0].tow = 0.f * texVerts[3].oow;
  
 grGlideGetState(&oldState);



   grAlphaBlendFunction( GR_BLEND_ONE, GR_BLEND_ONE,
			                               GR_BLEND_ONE, GR_BLEND_ZERO);
   guColorCombineFunction( GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB); 

   guTexSource(t->tex);
	
   guAlphaSource( GR_ALPHASOURCE_ITERATED_ALPHA);

   grTexCombineFunction(GR_TMU0, GR_TEXTURECOMBINE_SUBTRACT);



	        
	grDrawTriangle(&texVerts[0], &texVerts[1], &texVerts[2]);
	grDrawTriangle(&texVerts[2], &texVerts[3], &texVerts[0]);
        
        grGlideSetState(&oldState);


}


