#ifndef _GLFONT_H
#define _GLFONT_H

#include "textures.h"

#pragma warning(disable : 4244)

#define FONT_FIRST 2

#define FONT_X_COORD(c) ( (float)(c & 0x0F ) * (float)(fCellWidth) )
#define FONT_Y_COORD(c) ( (float)(c / 16) * fCellHeight )

static int Font_Initialized = 0;
static int iCellWidth = 8;
static int iCellHeight = 8;
static float fCellWidth = 0.0625;
static float fCellHeight = 0.0625;
static float FontTexWidth = 128.0;
static float FontTexHeight = 128.0;

int Font_Init(void);
int Font_LoadFont(char *filename, int num);
int Font_BlitString(char *s, float x, float y, int texnum);
int Font_BlitChar(char c, float x, float y, int texnum);


#pragma warning(default : 4244)

#endif