#include "glfont.h"
#include "gldemo.h"

#pragma warning(disable : 4244)

int Font_Init(void)
{	if ( !Font_Initialized )
	{	Font_Initialized = 1;
	}
	return 1;
}

int Font_LoadFont(char *filename, int fontnum)
{
	if ( !Font_Initialized )
	{	Font_Init();
	}
	return Load_Texture(filename, fontnum + FONT_FIRST);
}


int Font_BlitString(char *s, float x, float y, int texnum)
{
	int i, l;
	float x1, y1, x2, y2;

	l = strlen(s);
	if ( l==0 ) return 1;

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0, winX, winY, 0);
	glEnable (GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, texnum + FONT_FIRST);
	glDisable(GL_CULL_FACE);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glBegin(GL_QUADS);
	glColor4f(1.0, 1.0, 1.0, 0.5);

	for ( i=0; i<l; i++ )
	{	x1 = FONT_X_COORD(s[i]);
		x2 = x1 + fCellWidth;
		y1 = FONT_Y_COORD(s[i]);
		y2 = y1 + fCellHeight;

		glTexCoord2f(x1, y1);
		glVertex2f(x, y);

		glTexCoord2f(x2, y1);
		glVertex2f(x + (float)iCellWidth, y);
		
		glTexCoord2f(x2, y2);
		glVertex2f(x + (float)iCellWidth, y + (float)iCellHeight);

		glTexCoord2f(x1, y2);
		glVertex2f(x, y + (float)iCellHeight);

		x+=iCellWidth;
	}

	glEnd();
	glPopMatrix();

	return 1;
}


int Font_BlitChar(char c, float x, float y, int texnum)
{
	float x1, y1, x2, y2;

	x1 = FONT_X_COORD(c);
	x2 = x1 + fCellWidth;
	y1 = FONT_Y_COORD(c);
	y2 = y1 + fCellHeight;

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0, winWidth, winHeight, 0);
	glEnable (GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, texnum + FONT_FIRST);
	glDisable(GL_CULL_FACE);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glBegin(GL_QUADS);
	glColor4f(1.0, 1.0, 1.0, 0.5);

	glTexCoord2f(x1, y1);
	glVertex2f(x, y);

	glTexCoord2f(x2, y1);
	glVertex2f(x + (float)iCellWidth, y);

	glTexCoord2f(x2, y2);
	glVertex2f(x + (float)iCellWidth, y + (float)iCellHeight);

	glTexCoord2f(x1, y2);
	glVertex2f(x, y + (float)iCellHeight);

	glEnd();
	glPopMatrix();
	glDisable(GL_BLEND);

	return 1;
}


#pragma warning(default : 4244)