#include <math.h>
#include "mathlib.h"
#pragma warning(disable : 4244)

int M_VectMin(vec3_t v)
// returns 0, 1, or 2
{
	if ( v[0] < v[1] )
	{	return v[0] < v[2] ? 0:2;
	}
	return v[1] < v[2] ? 1:2;
}

int M_VectMax(vec3_t v)
// returns 0, 1, or 2
{
	if ( v[0] > v[1] )
	{	return v[0] > v[2] ? 0:2;
	}
	return v[1] > v[2] ? 1:2;
}

void M_AngToVects (vec3_t angles, vec3_t forward, vec3_t right, vec3_t up)
{
	float		angle;
	static float		sy, sp, sr, cy, cp, cr;
	// static to help MS compiler fp bugs

	angle = angles[YAW] * M_PI / 180.0; // convert to radians
	sy = sin(angle);
	cy = cos(angle);
	angle = angles[PITCH] * M_PI / 180.0;
	sp = sin(angle);
	cp = cos(angle);
	angle = angles[ROLL] * M_PI / 180.0;
	sr = sin(angle);
	cr = cos(angle);

	if (forward)
	{
		forward[0] = cp*cy;
		forward[1] = cp*-sy;
		forward[2] = sp;
	}
	if (right)
	{	//right[0] = sy*cr;
		
		right[0] = -1 * sr * sp * cy + cr * -sy;
		right[1] = (-1*sr*sp*sy+-1*cr*cy);
		right[2] = sr*cp;
		
	}
	if (up)
	{
		up[0] = -cr * sp * cy + sr * sy;
		up[1] = (cr*sp*sy+-sr*cy);
		up[2] = cr * cp;
	}
}


int VectorCompare (vec3_t v1, vec3_t v2)
{
	if (v1[0] != v2[0] || v1[1] != v2[1] || v1[2] != v2[2])
			return 0;
			
	return 1;
}


vec_t VectorNormalize (vec3_t v)
{
	float	length, ilength;

	length = v[0]*v[0] + v[1]*v[1] + v[2]*v[2];
	length = sqrt (length);		// FIXME

	if (length)
	{
		ilength = 1/length;
		v[0] *= ilength;
		v[1] *= ilength;
		v[2] *= ilength;
	}
		
	return length;

}

vec_t M_VectNormalize (vec3_t v, vec3_t out)
{
	float	length, ilength;

	length = v[0]*v[0] + v[1]*v[1] + v[2]*v[2];
	length = sqrt (length);		// FIXME

	if (length)
	{
		ilength = 1/length;
		out[0] = v[0]*ilength;
		out[1] = v[1]*ilength;
		out[2] = v[2]*ilength;
	}
		
	return length;

}

void VectorMA (vec3_t veca, float scale, vec3_t vecb, vec3_t vecc)
{
	vecc[0] = veca[0] + scale*vecb[0];
	vecc[1] = veca[1] + scale*vecb[1];
	vecc[2] = veca[2] + scale*vecb[2];
}

void M_CrossProd (vec3_t v1, vec3_t v2, vec3_t cross)
{
	cross[0] = v1[1]*v2[2] - v1[2]*v2[1];
	cross[1] = v1[2]*v2[0] - v1[0]*v2[2];
	cross[2] = v1[0]*v2[1] - v1[1]*v2[0];
}

vec_t VectorLength(vec3_t v)
{
	int		i;
	float	length;
	
	length = 0;
	for (i=0 ; i< 3 ; i++)
		length += v[i]*v[i];
	length = sqrt (length);		// FIXME

	return length;
}

void VectorInverse (vec3_t v)
{
	v[0] = -v[0];
	v[1] = -v[1];
	v[2] = -v[2];
}

void VectorScale (vec3_t in, vec_t scale, vec3_t out)
{
	out[0] = in[0]*scale;
	out[1] = in[1]*scale;
	out[2] = in[2]*scale;
}

void vectoangles (vec3_t value1, vec3_t angles)
{
	float	forward;
	float	yaw, pitch;
	
	if (value1[1] == 0 && value1[0] == 0)
	{
		yaw = 0;
		if (value1[2] > 0)
			pitch = 90;
		else
			pitch = 270;
	}
	else
	{
		yaw = (int) (atan2(value1[1], value1[0]) * 180 / M_PI);
		if (yaw < 0)
			yaw += 360;

		forward = sqrt (value1[0]*value1[0] + value1[1]*value1[1]);
		pitch = (int) (atan2(value1[2], forward) * 180 / M_PI);
		if (pitch < 0)
			pitch += 360;
	}

	angles[PITCH] = -pitch;
	angles[YAW] = yaw;
	angles[ROLL] = 0;
}
