#ifndef _MATHLIB_H
#define _MATHLIB_H

typedef float vec_t;
typedef vec_t vec2_t[2];
typedef vec_t vec3_t[3];
typedef vec3_t mat_t[3];

typedef struct orthoplane_s
{	int axis; // 0, 1, 2 = x, y, z respectively
	float dist; // distance from origin along above axis
					// front of plane is always along positive axis
} orthoplane_t;

#define ROLL 0
#define PITCH 1
#define YAW 2
#define M_PI 3.14159265358979323846

#define M_DotProd(x,y)				(x[0]*y[0]+x[1]*y[1]+x[2]*y[2])
#define M_VectAdd(a,b,c)			(c[0]=a[0]+b[0],c[1]=a[1]+b[1],c[2]=a[2]+b[2])
#define M_VectClr(a)					(a[0]=a[1]=a[2]=0)
#define M_VectCmp(a,b)				(a[0]==b[0]&&a[1]==b[1]&&a[2]==b[2])
#define M_VectCpy(a,b)				(b[0]=a[0],b[1]=a[1],b[2]=a[2])
#define M_VectNeg(a,b)				(b[0]=-a[0],b[1]=-a[1],b[2]=-a[2])
#define M_VectSet(v, x, y, z)		(v[0]=(x), v[1]=(y), v[2]=(z))
#define M_VectSub(a,b,c)			(c[0]=a[0]-b[0],c[1]=a[1]-b[1],c[2]=a[2]-b[2])
#define M_VectScale(a,s,b)			(b[0]=a[0]*s, b[1]=a[1]*s, b[2]=a[2]*s) 
#define M_VectMultAdd(a,b,s,c)	(c[0]=a[0]+s*b[0],c[1]=a[1]+s*b[1],c[2]=a[2]+s*b[2])

int M_VectMin(vec3_t v);	// returns 0, 1, or 2
int M_VectMax(vec3_t v);	// returns 0, 1, or 2
void M_AngToVects(vec3_t angles, vec3_t forward, vec3_t right, vec3_t up);
vec_t M_VectNormalize(vec3_t v, vec3_t out);
void M_CrossProd(vec3_t v1, vec3_t v2, vec3_t cross);
vec_t M_VectLen(vec3_t v);
void M_VectToAng(vec3_t value1, vec3_t angles);

void M_MakeIdentyMatrix(mat_t m);
void M_ConcatMatrices(mat_t in1, mat_t in2, mat_t out);
void M_RotateMatrix(mat_t m, vec3_t angles);


#endif