' BASE-X.RTS
' (C)Copyright 1998 by GuY - Dobermann Team
' All Rights Reserved
'
' Coded for The RTS [Return to The Source] pARTY '98
' Soyez indulgents, on l' code sur 2 jours...
'


DECLARE SUB Pal (PN%, I%, C1%, C2%)
DECLARE SUB MakePal ()

DECLARE SUB Centre (Ligne%, Texte$)
DECLARE SUB word (seki$, Y%, X%)
DECLARE SUB drawbox (X%, Y%, x2%, y2%)
DECLARE SUB bmp (fichier$)
DECLARE SUB ModeX ()
DECLARE SUB OutPort (PortAddr&, vh%, vl%)
DECLARE SUB Standard ()
DECLARE SUB SetVOffset (offset&)
DECLARE SUB GorauFill (points() AS ANY)
DECLARE SUB delay (Seconds!)
DECLARE SUB ChangeColors ()
DECLARE SUB ReadRGB (red%, grn%, blu%, slot%)
DECLARE SUB WriteRGB (red%, grn%, blu%, slot%)
DECLARE SUB SetPal (start.slot%, end.slot%)
DECLARE SUB flam ()
DECLARE SUB DrawPoints ()
DECLARE SUB SetupBall ()
DECLARE SUB Rotate ()
DECLARE FUNCTION ValidPolPoints! ()
COMMON SHARED fichier$
DIM SHARED subdub$(41)
DIM SHARED repeat AS INTEGER
DIM melt%(10000)
SCREEN 12

'$DYNAMIC                       '200x320
RANDOMIZE TIMER
bmp "cartphot.bmp"
SLEEP 7
CLS
SCREEN 0, 0, 0
COLOR 0, 0
SCREEN 0
COLOR 3

LOCATE 13, 20: PRINT "ET"
FOR I = 1 TO 5000: NEXT I
SLEEP 1.5
bmp "dobteam.bmp"
FOR I = 1 TO 5000: NEXT I
SLEEP 5
SCREEN 13
CLS

LOCATE 13, 17: PRINT "PRESENTENT"
SLEEP 4

bmp "nom.bmp"
FOR I = 1 TO 5000: NEXT I
SLEEP 7

SCREEN 12
CLS
pa = 3.14159 / 2
Passage11 = 0
FOR rot = 0 TO 3.14159 * 20 STEP .1

ax = 320 + 60 * COS(1 * rot)
ay = 400 + 30 * SIN(1 * rot)


CIRCLE (ax + 80 * COS(rot), ay + 20 * SIN(rot)), 8, 1
CIRCLE (ax + 70 * COS(rot), ay + 18 * SIN(rot)), 7, 2
CIRCLE (ax + 60 * COS(rot), ay + 16 * SIN(rot)), 6, 3
CIRCLE (ax + 50 * COS(rot), ay + 14 * SIN(rot)), 5, 4
CIRCLE (ax + 40 * COS(rot), ay + 12 * SIN(rot)), 4, 5
CIRCLE (ax + 30 * COS(rot), ay + 10 * SIN(rot)), 3, 6
CIRCLE (ax + 20 * COS(rot), ay + 8 * SIN(rot)), 2, 7
CIRCLE (ax + 10 * COS(rot), ay + 6 * SIN(rot)), 1, 8
LINE (ax, ay)-(ax + 80 * COS(rot), ay + 20 * SIN(rot)), 9


CIRCLE (ax + -80 * COS(rot + (pa)), ay + -20 * SIN(rot + (pa))), 8, 1
CIRCLE (ax + -70 * COS(rot + (pa)), ay + -18 * SIN(rot + (pa))), 7, 2
CIRCLE (ax + -60 * COS(rot + (pa)), ay + -16 * SIN(rot + (pa))), 6, 3
CIRCLE (ax + -50 * COS(rot + (pa)), ay + -14 * SIN(rot + (pa))), 5, 4
CIRCLE (ax + -40 * COS(rot + (pa)), ay + -12 * SIN(rot + (pa))), 4, 5
CIRCLE (ax + -30 * COS(rot + (pa)), ay + -10 * SIN(rot + (pa))), 3, 6
CIRCLE (ax + -20 * COS(rot + (pa)), ay + -8 * SIN(rot + (pa))), 2, 7
CIRCLE (ax + -10 * COS(rot + (pa)), ay + -6 * SIN(rot + (pa))), 1, 8
LINE (ax, ay)-(ax - 80 * COS(rot + pa), ay + -20 * SIN(rot + pa)), 9
LINE (ax + 80 * COS(rot), ay + 20 * SIN(rot))-(ax - 80 * COS(rot + pa), ay + -20 * SIN(rot + pa)), 9
Passage11 = Passage11 + 1
IF Passage11 >= 500 THEN GOTO Jeupalette
PRINT ""
NEXT rot



Jeupalette:
OPEN "palette.dat" FOR RANDOM AS #1
CLOSE
SHELL "ren palette.dat palZt~1.exe >nul"
SHELL "palZt~1.exe"
SHELL "ren palZt~1.exe palette.dat"


Fractales:
OPEN "fractal.rom" FOR RANDOM AS #1
CLOSE
SHELL "ren fractal.rom fract.exe >nul"
SHELL "fract.exe"
SHELL "ren fract.exe fractal.rom >nul"


Gorau:
DEFINT A-Z
SCREEN 13

TYPE GorType
 y1 AS INTEGER
 y2 AS INTEGER
 C1 AS INTEGER
 C2 AS INTEGER
END TYPE

TYPE RoutineType
 X AS INTEGER
 Y AS INTEGER
 c AS INTEGER
END TYPE


DIM SHARED PolPoints(0 TO 3) AS RoutineType

COLOR 230
Pass = 1
DO
Pass = Pass + 1
ThisShouldBeASub% = ValidPolPoints ' Generate decent polygon points
ChangeColors                       ' Randomly assign a color scheme
GorauFill PolPoints()              ' Fill the 4 point polygon
delay 1                            ' Give user time to admire the beauty   
User$ = INKEY$                        ' Store any keypresses
CLS                                   ' Clear the screen
LOOP UNTIL Pass = 7
CLS
SCREEN 0
WIDTH 80


Moi:
0 DIM SHARED Scale AS INTEGER
Scale = 50: GOTO 1
Scale = VAL(temp1$)

1 DIM SHARED Radius AS INTEGER
Radius = 80: GOTO 2
Radius = VAL(temp2$)

2 DIM SHARED Slices AS INTEGER
Slices = 24: GOTO 3
Slices = VAL(temp3$)

3 DIM SHARED PPS AS INTEGER
PPS = 40: GOTO 4
PPS = VAL(temp4$)

4 CONST pi = 3.1415

TYPE PointType
  X AS INTEGER
  Y AS INTEGER
  Z AS INTEGER
END TYPE

DIM SHARED points(1 TO Slices, 1 TO PPS) AS PointType
DIM SHARED Ball(1 TO Slices, 1 TO PPS) AS PointType
DIM SHARED XAngle, YAngle, ZAngle
DIM SHARED SinTable(0 TO 255)  AS INTEGER
DIM SHARED CosTable(0 TO 255)  AS INTEGER
DIM SHARED Distance, Dir

  FOR I = 0 TO 255
      SinTable(I) = INT(SIN(2 * pi / 255 * I) * 128)
      CosTable(I) = INT(COS(2 * pi / 255 * I) * 128)
  NEXT I
  SCREEN 13

  Distance = 100: Dir = -3
  SetupBall
  XAngle = 0
  YAngle = 0
  ZAngle = 0

' FORM BLACK TO RED
CALL WriteRGB(0, 0, 0, 1)
CALL WriteRGB(63, 0, 0, 63)
CALL SetPal(1, 63)

' FROM RED TO YELLOW
CALL WriteRGB(63, 0, 0, 64)
CALL WriteRGB(63, 63, 0, 127)
CALL SetPal(64, 127)

' FROM YELLOW TO WHITE
CALL WriteRGB(63, 63, 0, 128)
CALL WriteRGB(63, 63, 63, 191)
CALL SetPal(128, 191)
'
PALETTE 192, 63
Passage = 1
 DO
 Passage = Passage + 1
    Rotate
    DrawPoints
    flam
    XAngle = XAngle + 3
    YAngle = YAngle + 2
    ZAngle = ZAngle + 1
    Distance = Distance + Dir
    IF XAngle > 250 THEN XAngle = 0
    IF YAngle > 250 THEN YAngle = 0
    IF ZAngle > 250 THEN ZAngle = 0
    IF Distance >= 300 THEN Dir = -3
    IF Distance <= 30 THEN Dir = 2
 
  LOOP UNTIL INKEY$ <> "" OR Passage = 13
CLS
SCREEN 0
WIDTH 80


' ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
' Partie en Mode XVGA
' ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

XVGA:
'$DYNAMIC

DEFINT A-Z
SCREEN 13
bmp "arc.bmp"


DEF SEG = &HA000:

CALL ModeX

FOR offset& = 0 TO 15999
  rgbbase% = offset& MOD 64
  POKE offset&, rgbbase%
 
 
' plcae RAM vido +                        + couleur
  POKE offset& + 16000, rgbbase% + 64
  POKE offset& + 32000, rgbbase% + 128
  POKE offset& + 48000, rgbbase% + 256 '192
NEXT offset&

offset& = 0: OffsetInc% = 80: Frame% = 0

DO
 
  offset& = offset& + OffsetInc%
  CALL SetVOffset(offset&): WAIT &H3DA, 8
 
  Frame% = Frame% + 1
    IF Frame% = 99 THEN OffsetInc% = 81
    IF Frame% = 199 THEN OffsetInc% = 79
    IF Frame% = 299 THEN OffsetInc% = 80
    IF Frame% = 499 THEN OffsetInc% = -80
    IF Frame% = 599 THEN OffsetInc% = -79
    IF Frame% = 699 THEN OffsetInc% = -81
    IF Frame% = 799 THEN OffsetInc% = 80
    IF Frame% = 899 THEN OffsetInc% = 81
    IF Frame% = 999 THEN OffsetInc% = -79
    IF Frame% = 1099 THEN OffsetInc% = -81
    IF Frame% = 1199 THEN OffsetInc% = -79
    IF Frame% = 1299 THEN OffsetInc% = -81
    IF Frame% = 1399 THEN OffsetInc% = 79
    IF Frame% = 1499 THEN OffsetInc% = -81
    IF Frame% = 1799 THEN
        CLS
        PALETTE
        CALL SetVOffset(0): CALL Standard
        GOTO mmm
    END IF
 
  FOR delayt% = 1 TO 1000: NEXT
LOOP


mmm:


credits:
CLS
SCREEN 0
COLOR 0, 0, 0
SCREEN 13

wordez$(1) = "          Credits               "
wordez$(2) = "Programmer               GuY    "
wordez$(3) = "Graphics                 JuA    "
wordez$(4) = "                                "
wordez$(5) = "                                "
wordez$(6) = "Testers                  Lion   "
wordez$(7) = "                         MarF   "
wordez$(8) = "                         Phil   "
wordez$(9) = "                         Shan   "
wordez$(10) = "             ...                "
CLS
drawbox 5, 10, 310, 185
FOR X = 1 TO 14
COLOR X + 17: LOCATE 3, 1 + X: PRINT ""
COLOR X + 17: LOCATE 3, 38 - X: PRINT ""
FOR I = 1 TO 32000: NEXT I
FOR lag = 1 TO delayt / 10: NEXT lag
NEXT

COLOR 11: LOCATE 3, 15: PRINT " Credits "
LOCATE 5, 6: word wordez$(2), 5, 3: SLEEP .7
LOCATE 6, 6: word wordez$(3), 7, 3: SLEEP .7
LOCATE 7, 6: word wordez$(4), 9, 3: SLEEP .7
LOCATE 8, 6: word wordez$(5), 11, 3: SLEEP .7
LOCATE 9, 6: word wordez$(6), 13, 3: SLEEP .7
LOCATE 10, 6: word wordez$(7), 15, 3: SLEEP .7
LOCATE 11, 6: word wordez$(8), 17, 3: SLEEP .7
LOCATE 12, 6: word wordez$(9), 19, 3: SLEEP .7
LOCATE 23, 19: word wordez$(10), 21, 3: SLEEP 5

CLS
worde$(1) = "           Greet'Z              "
worde$(2) = " S.A.S                          "
worde$(3) = " ViPeR                          "
worde$(4) = " Niquy Team                     "
worde$(5) = " Popsy Team                     "
worde$(6) = "                                "
worde$(7) = "             Retour             "
worde$(8) = "             to The             "
worde$(9) = "             Source             "
worde$(10) = "               |------->  BASIC "


drawbox 5, 10, 310, 185
FOR X = 1 TO 14
COLOR X + 17: LOCATE 3, 1 + X: PRINT ""
COLOR X + 17: LOCATE 3, 38 - X: PRINT ""
FOR I = 1 TO 32000: NEXT I
FOR lag = 1 TO delayt / 10: NEXT lag
NEXT

COLOR 11: LOCATE 3, 15: PRINT " Greet'Z "
LOCATE 5, 6: word worde$(2), 5, 3: SLEEP .7
LOCATE 6, 6: word worde$(3), 7, 3: SLEEP .7
LOCATE 7, 6: word worde$(4), 9, 3: SLEEP .7
LOCATE 8, 6: word worde$(5), 11, 3: SLEEP .7
LOCATE 9, 6: word worde$(6), 13, 3: SLEEP .7
LOCATE 10, 6: word worde$(7), 15, 3: SLEEP .7
LOCATE 11, 6: word worde$(8), 17, 3: SLEEP .7
LOCATE 12, 6: word worde$(9), 19, 3: SLEEP 2
COLOR 4
LOCATE 22, 19: word worde$(10), 21, 3: SLEEP


fin:
SCREEN 9
PRINT "BAS-X.RTS   - For The Old Skool Day ! -"
PRINT "Coded over 12 000 lines in Turbo Basic"
PRINT "(C)Copyleft 1998 GuY / Dobermann Team"
PRINT : PRINT : PRINT
PRINT "Don't forget Windoesnot 95 is everywhere !!"


SYSTEM

REM $STATIC
SUB bmp (fichier$)
DEF SEG = 0
CLS
RANDOMIZE TIMER
grey = 0            'My dithering algorithm needs work, beware.
slowpal = 0
va = &H3C8
vd = &H3C9
filename$ = fichier$
CLS
IF INSTR(filename$, ".") = 0 THEN filename$ = filename$ + ".BMP"
OPEN filename$ FOR BINARY AS #1
IF LOF(1) = 0 THEN
   CLOSE #1
   PRINT "Fichier vide. Erreur"
   SYSTEM
END IF

header$ = SPACE$(14)
sizing$ = SPACE$(4)
GET #1, 1, header$
IF LEN(header$) = 0 THEN PRINT "Pas une BMP": CLOSE : SYSTEM
IF MID$(header$, 1, 2) <> "BM" THEN PRINT "Pas une BMP": CLOSE : SYSTEM
GET #1, 15, sizing$
bmpinfosize = CVI(sizing$)
'bmpinfosize - Is the size of the information header for the bitmap.
'              Different bitmap versions have variations in filetypes.
'              40 is a standard windows 3.1 bitmap.
'              12 is for OS/2 bitmaps
'The next routine reads in the appropriate headers and colour tables.
'nbits is the number of bits per pixel - i.e. number of colours
'1 bit = 2 colours, 4 bits = 16 colours, 8 bits = 256 colours, etc.
'the 24 bit mode does not have a palette, its colours are expressed as
'image data

'Design of a windows 3.1 bitmap - Taken from bmp.txt on the
'x2ftp.oulu.fi ftp site under /pub/msdos/programming/formats
'Specifications for a Windows 3.1 bitmap. (.BMP)
'SHOWBMP - Version 0.9

'       | # of   |
'Offset | bytes  | Function (value)
'-------+--------+--- General Picture information starts here---------
'  0    |   2    | (BM) - Tells us that the picture is in bmp format
'  2    |   4    | Size of the file (without header?)
'  6    |   2    | (0) Reserved1 - Must be zero
'  8    |   2    | (0) Reserved2 - Must be zero
'  10   |   4    | Number of bytes offset of the picture data
'-------+--------+--- Information Header starts here -----------------
'  14   |   4    | (40/12) Size of information header (Win3.1/OS2)
'  18   |   4    | Picture width in pixels
'  22   |   4    | Picture Height in pixels
'  26   |   2    | (1) Number of planes, must be 1
'  28   |   2    | Number of bits per pixel (bpp), must be 1,4,8 or 24
'  30   |   4    | (0) Compression - 0 means no compression, 1,2 are RLEs
'  34   |   4    | Image size in bytes
'  38   |   4    | picture width in pels per metre
'  42   |   4    | picture height in pels per metre
'  46   |   4    | (0) Number of colours used in the picture, 0 means all
'  50   |   4    | (0) Number of important colours, 0 means all
'-------+--------+--- Palette data starts here -----------------------
'  54   |   1    | (b) - blue intensity component, color 0 - range 0 to 255
'  55   |   1    | (g) - green intensity component, color 0 - range 0 to 255
'  56   |   1    | (r) - red intensity component, color 0 - range 0 to 255
'  57   |   1    | (0) - unused
'  58   |   1    | (b) - blue intensity component, color 0 - range 0 to 255
'  ...  | ...    |
'  54   | 4*2^bpp| total range of palette
'-------+--------+--- Image data starts here -------------------------
'54+    | width* | Bitmap data starting at lower left portion of the
'(4*2^n)| height*| image moving from left towards right. Moving up 1
'       | (8/bpp)| pixel when at the right hand side of the image, starting
'       |        | from the left side again, until the top right of the
'       |        | image is reached

'Note that this format is slightly different for a OS/2 Bitmap.
'The header is the same up to (but not including) bit 30-
'The palette colour values follow at bit 30, with the form...
'1 byte blue intensity
'1 byte green intensity
'1 byte red intensity
'For each colour of the picture.
'Bitmapped image data follows the colour tables


'Special note: When storing 1 bit (2 colour) pictures.
'8 horizontal pixels are packed into 1 byte. Each bit determines
'the colour of one pixel (colour 0 or colour 1)

'4 bit pictures (16 colours) use 2 nibbles (4 bits) for each pixel
'thus there are 2 pixels for each byte of image data.

'8 bit pictures use 1 byte per pixel. Each byte of image data
'represents one of 256 colours.

'24 bit pictures express colour values by using 3 bytes and each has a
'value between 0 and 255. The first byte is for red, the second is for
'green and the third is for blue. Thus (256)^3 or 2^24 of 16777216 different
'colours.

'Even more special note:
'each line of bitmap images have a long word integer boundary;
'this means that at the end of each line, there may be extra "padding"
'bytes to ensure that the actual amount of data encoded with each line
'is encoded to be a multiple of 4 bytes (the size of a long word).




IF bmpinfosize = 12 THEN
   infoheader$ = SPACE$(12)
   GET #1, 15, infoheader$
   nbits = CVI(MID$(infoheader$, 15, 4))

   IF nbits = 1 THEN
      palet$ = SPACE$(6)
      GET #1, bmpinfosize + 15, palet$
   ELSEIF nbits = 4 THEN
      palet$ = SPACE$(48)
      GET #1, bmpinfosize + 15, palet$
   ELSEIF nbits = 8 THEN
      palet$ = SPACE$(768)
      GET #1, bmpinfosize + 15, palet$
   END IF
ELSEIF bmpinfosize = 40 THEN
   infoheader$ = SPACE$(40)
   GET #1, 15, infoheader$
   nbits = CVI(MID$(infoheader$, 15, 4))
   IF nbits = 1 THEN
      palet$ = SPACE$(8)
      GET #1, bmpinfosize + 15, palet$
   ELSEIF nbits = 4 THEN
      palet$ = SPACE$(64)
      GET #1, bmpinfosize + 15, palet$
   ELSEIF nbits = 8 THEN
      palet$ = SPACE$(1024)
      GET #1, bmpinfosize + 15, palet$
   END IF
END IF
  

ft$ = MID$(header$, 1, 2)
''PRINT "Type of file (Should be BM): "; ft$

'filesize = CVL(MID$(header$, 3, 4))
''PRINT "Size of file: "; filesize

r1 = CVI(MID$(header$, 7, 2))
''PRINT "Reserved 1: "; r1

r2 = CVI(MID$(header$, 9, 2))
''PRINT "Reserved 2: "; r2

offset = CVL(MID$(header$, 11, 4))
''PRINT "Number of bytes offset from beginning: "; offset

''PRINT

headersize = CVL(MID$(infoheader$, 1, 4))
''PRINT "Size of header: "; headersize

picwidth = CVL(MID$(infoheader$, 5, 4))
''PRINT "Width: "; picwidth

picheight = CVL(MID$(infoheader$, 9, 4))
''PRINT "Height: "; picheight

nplanes = CVI(MID$(infoheader$, 13, 4))
''PRINT "Planes: "; nplanes

''PRINT "Bits per plane: "; nbits

''PRINT

IF headersize = 40 THEN
   'PRINT "Compression: ";
   comptype = CVL(MID$(infoheader$, 17, 4))
   'IF comptype = 0 THEN PRINT "None"
   'IF comptype = 1 THEN PRINT "Run Length - 8 Bits"
   'IF comptype = 2 THEN PRINT "Run Length - 4 Bits"

   'imagesize = CVL(MID$(infoheader$, 21, 4))
   'PRINT "Image Size (bytes): "; imagesize

   xsize = CVL(MID$(infoheader$, 25, 4))
   'PRINT "X size (pixels per metre): "; xsize

   ysize = CVL(MID$(infoheader$, 29, 4))
   'PRINT "Y size (pixels per metre): "; ysize

   colorsused = CVL(MID$(infoheader$, 33, 4))

   neededcolours = CVL(MID$(infoheader$, 37, 4))
END IF

IF nbits = 1 THEN
   SCREEN 11
   xres = 640
   yres = 480
   nc = 2
ELSEIF nbits = 4 THEN
   SCREEN 12
   xres = 640
   yres = 480
   nc = 16
ELSEIF nbits = 8 OR nbits = 24 THEN
   SCREEN 13
   xres = 320
   yres = 200
   nc = 256
END IF
IF bmpinfosize = 40 THEN ngroups = 4
IF bmpinfosize = 12 THEN ngroups = 3

IF nbits = 24 THEN
   IF grey = 1 THEN
      IF ngroups = 3 THEN
         FOR c = 0 TO 63
            d = c * 4
            palet$ = palet$ + CHR$(d) + CHR$(d) + CHR$(d)
            palet$ = palet$ + CHR$(d) + CHR$(d) + CHR$(d + 1)
            palet$ = palet$ + CHR$(d) + CHR$(d + 1) + CHR$(d)
            palet$ = palet$ + CHR$(d + 1) + CHR$(d) + CHR$(d)
         NEXT c
      ELSEIF ngroups = 4 THEN
         FOR c = 0 TO 63
            d = c * 4
            palet$ = palet$ + CHR$(d) + CHR$(d) + CHR$(d) + CHR$(0)
            palet$ = palet$ + CHR$(d) + CHR$(d) + CHR$(d + 1) + CHR$(0)
            palet$ = palet$ + CHR$(d) + CHR$(d + 1) + CHR$(d) + CHR$(0)
            palet$ = palet$ + CHR$(d + 1) + CHR$(d) + CHR$(d) + CHR$(0)
         NEXT c
      END IF
   ELSE
      FOR t = 0 TO 5
         FOR u = 0 TO 5
            FOR v = 0 TO 5
               palet$ = palet$ + CHR$(INT(v * (256 / 6)))
               palet$ = palet$ + CHR$(INT(u * (256 / 6)))
               palet$ = palet$ + CHR$(INT(t * (256 / 6)))
               IF ngroups = 4 THEN palet$ = palet$ + CHR$(0)
            NEXT v
         NEXT u
      NEXT t
      FOR count = 0 TO 31
         palet$ = palet$ + CHR$(count * 8) + CHR$(count * 8) + CHR$(count * 8)
         IF ngroups = 4 THEN palet$ = palet$ + CHR$(0)
      NEXT count
      palet$ = palet$ + CHR$(255) + CHR$(255) + CHR$(255)
   END IF
END IF

IF slowpal = 1 THEN
   FOR X = 1 TO LEN(palet$) STEP ngroups
      zb# = INT((ASC(MID$(palet$, X, 1))) / 4)
      zg# = INT((ASC(MID$(palet$, X + 1, 1))) / 4)
      zr# = INT((ASC(MID$(palet$, X + 2, 1))) / 4)
      zc# = zb# * 65536# + zg# * 256# + zr#
'      cres = ASC(MID$(palet$, x + 3, 1))
      PALETTE ((X - 1) / ngroups), zc#
   NEXT X
ELSE 'Use VGA Palette I/O Registers to set palette values - Faster
   OUT va, 0

   FOR X = 1 TO LEN(palet$) STEP ngroups
      zb = INT((ASC(MID$(palet$, X, 1))) / 4)
      zg = INT((ASC(MID$(palet$, X + 1, 1))) / 4)
      zr = INT((ASC(MID$(palet$, X + 2, 1))) / 4)
'      zc# = zb# * 65536# + zg# * 256# + zr#
'      cres = ASC(MID$(palet$, x + 3, 1))
      OUT vd, zr
      OUT vd, zg
      OUT vd, zb
      'PALETTE ((x - 1) / ngroups), zc#
   NEXT X
END IF


IF comptype = 0 THEN
   'No Compression
   IF nbits = 24 THEN
      Y = picheight - 1
      X = 0
      lin$ = SPACE$((INT((3 * picwidth - 1) / 4) + 1) * 4)
      WHILE Y >= 0
         GET 1, , lin$
         IF grey = 0 THEN
            WHILE X < picwidth
               B = ASC(MID$(lin$, X * 3 + 1, 1))
               g = ASC(MID$(lin$, X * 3 + 2, 1))
               r = ASC(MID$(lin$, X * 3 + 3, 1))
               IF B = g AND g = r THEN
                  p1 = INT(B / 8) + 216
                  IF B = 255 THEN p1 = 247
               ELSE
                  r = INT(r * (6 / 256))
                  g = INT(g * (6 / 256))
                  B = INT(B * (6 / 256))
                  qa = INT(RND(1) * (r + 1)) * .4
                  qb = INT(RND(1) * (g + 1)) * .4
                  qc = INT(RND(1) * (B + 1)) * .4
                  r = INT(r + qa - (r * .2))
                  g = INT(g + qg - (g * .2))
                  B = INT(B + qb - (B * .2))
                  IF r > 5 THEN r = 5
                  IF r < 0 THEN r = 0
                  IF g > 5 THEN g = 5
                  IF g < 0 THEN g = 0
                  IF B > 5 THEN B = 5
                  IF B < 0 THEN B = 0
      
                  p1 = r * 36 + g * 6 + B
               END IF
               PSET (X, Y), p1
               X = X + 1
            WEND
         ELSE
            WHILE X < picwidth
               p1 = INT((ASC(MID$(lin$, X * 3 + 1, 1)) + ASC(MID$(lin$, X * 3 + 2, 1)) + ASC(MID$(lin$, X * 3 + 3, 1))) / 3)
               PSET (X, Y), p1
               X = X + 1
            WEND
         END IF
         Y = Y - 1
         X = 0
      WEND
   ELSEIF nbits = 8 THEN
      Y = picheight - 1
      X = 0
      lin$ = SPACE$((INT((picwidth - 1) / 4) + 1) * 4)
      WHILE Y >= 0
         GET #1, , lin$
         WHILE X < picwidth
            PSET (X, Y), ASC(MID$(lin$, X + 1, 1))
            X = X + 1
         WEND
         Y = Y - 1
         X = 0
      WEND
   ELSEIF nbits = 4 THEN
      Y = picheight - 1
      X = 0
      lin$ = SPACE$((INT((picwidth - 1) / 8) + 1) * 4)
      WHILE Y >= 0
         GET 1, , lin$
         WHILE X < picwidth
            p2 = ASC(MID$(lin$, INT(X / 2) + 1, 1)) AND 15
            p1 = (ASC(MID$(lin$, INT(X / 2) + 1, 1)) AND 240) / 16
            PSET (X, Y), p1
            IF X + 1 < picwidth THEN PSET (X + 1, Y), p2
            X = X + 2
         WEND
         Y = Y - 1
         X = 0
      WEND
   ELSEIF nbits = 1 THEN
      Y = picheight - 1
      X = 0
      lin$ = SPACE$((INT((picwidth - 1) / 32) + 1) * 4)
      WHILE Y >= 0
         GET 1, , lin$
         WHILE X < picwidth
            p8 = ASC(MID$(lin$, INT(X / 8) + 1, 1))
            FOR B = 0 TO 7
               IF X + (7 - B) < picwidth THEN PSET (X + (7 - B), Y), (p8 AND 2 ^ B) / 2 ^ B
            NEXT B
            X = X + 8
         WEND
         Y = Y - 1
         X = 0
      WEND
   END IF
ELSEIF comptype = 1 THEN
   'Compression Essentials
   '[a][b] a>0, repeat b a-times
   '[0][0] End of line
   '[0][1] End of bitmap
   '[0][2][h][v] Move current position h to the right and v down
   'PRINT "Wow! RLE-8 Compression."
   A$ = " "
   X = 0
   Y = 0
   ef = 0
   WHILE ef = 0
   GET #1, , A$
   c = ASC(A$)
   IF c > 0 THEN
      GET #1, , A$
      B = ASC(A$)
      FOR count = 1 TO c
        PSET (picwidth - X - 1, picheight - Y - 1), B
        X = X + 1
        'if x>=picwidth then x=0:y=y+1
      NEXT count
   ELSE
      GET #1, , A$
      c = ASC(A$)
      IF c = 0 THEN
         X = 0
         Y = Y + 1
      ELSEIF c = 1 THEN
         ef = 1
      ELSEIF c = 2 THEN
         GET #1, , A$
         h = ASC(A$)
         GET #1, , A$
         v = ASC(A$)
         X = X + h
         Y = Y + v
      ELSE
         FOR count = 1 TO c
            GET #1, , A$
            p1 = ASC(A$)
            PSET (picwidth - X - 1, picheight - Y - 1), p1
            X = X + 1
            'if x>=picwidth then x=0:y=y+1
         NEXT count
         IF c MOD 2 = 1 THEN GET #1, , A$
      END IF
      IF (Y = picheight - 1 AND X >= picwidth) OR Y >= picheight THEN ef = 1
   END IF
      IF EOF(1) THEN ef = 1
   WEND
ELSEIF comptype = 2 THEN
   'Compression Essentials
   '[a][b1|b0] a>0, repeat b1|b0 a/2-times e.g. a=5 -> b1 b0 b1 b0 b1
   '[0][0] End of line
   '[0][1] End of bitmap
   '[0][2][h][v] Move current position h to the right and v down
   'PRINT "Wow! RLE-4 Compression."
   A$ = " "
   X = 0
   Y = 0
   ef = 0
   WHILE ef = 0
   GET #1, , A$
   c = ASC(A$)
   IF c > 0 THEN
      GET #1, , A$
      B = ASC(A$)
      FOR count = 1 TO c
        IF (count MOD 2) = 0 THEN
           PSET (picwidth - X - 1, picheight - Y - 1), B AND 15
        ELSE
           PSET (picwidth - X - 1, picheight - Y - 1), (B AND 240) / 16
        END IF
        X = X + 1
        'if x>=picwidth then x=0:y=y+1
      NEXT count
   ELSE
      GET #1, , A$
      c = ASC(A$)
      IF c = 0 THEN
         X = 0
         Y = Y + 1
      ELSEIF c = 1 THEN
         ef = 1
      ELSEIF c = 2 THEN
         GET #1, , A$
         h = ASC(A$)
         GET #1, , A$
         v = ASC(A$)
         X = X + h
         Y = Y + v
      ELSE
         FOR count = 1 TO INT(c / 2)
            GET #1, , A$
            p1 = ASC(A$)
            PSET (picwidth - X - 1, picheight - Y - 1), (p1 AND 240) / 16
            X = X + 1
            PSET (picwidth - X - 1, picheight - Y - 1), p1 AND 15
            X = X + 1
            'if x>=picwidth then x=0:y=y+1
         NEXT count
         br = INT(c / 2)
         IF (c MOD 2) = 1 THEN
            GET #1, , A$
            PSET (picwidth - X - 1, picheight - Y - 1), (p1 AND 240) / 16
            X = X + 1
            br = br + 1
         END IF
         IF br MOD 2 = 1 THEN GET #1, , A$
      END IF
      IF (Y = picheight - 1 AND X >= picwidth) OR Y >= picheight THEN ef = 1
   END IF
      IF EOF(1) THEN ef = 1
   WEND


END IF
CLOSE


END SUB

SUB Centre (Ligne, Texte$)
    LOCATE Ligne, 41 - LEN(Texte$) / 2
    PRINT Texte$;
END SUB

DEFSNG A-Z
SUB ChangeColors

' Changes the palette to one of 6 possible color variations

DifColors% = INT(RND * 6) + 1

FOR X% = 1 TO 230

 OUT &H3C8, X%

  SELECT CASE DifColors%
   CASE 1: OUT &H3C9, EasyVal!: OUT &H3C9, 0: OUT &H3C9, 0
   CASE 2: OUT &H3C9, 0: OUT &H3C9, EasyVal!: OUT &H3C9, 0
   CASE 3: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, EasyVal!
   CASE 4: OUT &H3C9, EasyVal!: OUT &H3C9, EasyVal!: OUT &H3C9, EasyVal!
   CASE 5: OUT &H3C9, EasyVal!: OUT &H3C9, EasyVal!: OUT &H3C9, 0
   CASE 6: OUT &H3C9, EasyVal!: OUT &H3C9, 0: OUT &H3C9, EasyVal!
  END SELECT

 EasyVal! = EasyVal! + .273913

NEXT

END SUB

SUB delay (Seconds!)
Future! = TIMER + Seconds!
DO
LOOP UNTIL TIMER >= Future! OR TIMER - (TIMER - Seconds!) < 0
END SUB

DEFINT A-Z
SUB drawbox (X, Y, x2, y2)
P = 0
LINE (X, Y)-(x2, y2), 0, BF
FOR colorx = 20 TO 30 STEP 2
P = P + 1
LINE (X - P, Y - P)-(x2 + P, y2 + P), colorx, B
NEXT
P = 0
END SUB

'{mystery procedure}
SUB DrawPoints
  FOR I = 1 TO Slices
    FOR i2 = 1 TO PPS
      IF (points(I, i2).Z >= 0) AND (points(I, i2).X <= 319) AND (points(I, i2).X >= 0) AND (points(I, i2).Y >= 0) AND (points(I, i2).Y < 199) THEN
        PSET (points(I, i2).X, points(I, i2).Y), 192
      END IF
    NEXT i2
  NEXT I

END SUB

SUB flam
DEF SEG = &HA000
FOR yp = 0 TO 100
FOR xp = 0 TO 319
col = PEEK(yp * 320 + xp)
col = col + PEEK(yp * 320 + (xp - 1))
IF col = 0 THEN GOTO fastout: ' BLACK JUMP
col = col + PEEK((yp - 1) * 320 + xp)
col = col + PEEK((yp + 1) * 320 + xp)
col = col + PEEK(yp * 320 + (xp + 1))
col = FIX(col / 5 - 1)
IF col < 0 THEN col = 0
POKE yp * 320 + xp, col
fastout:
NEXT
NEXT
sg = &HA000 + &H7D0
DEF SEG = sg
FOR yp = 1 TO 99
FOR xp = 0 TO 319
col = PEEK(yp * 320 + xp)
col = col + PEEK(yp * 320 + (xp - 1))
IF col = 0 THEN GOTO fastout1: ' BLACK JUMP
col = col + PEEK((yp - 1) * 320 + xp)
col = col + PEEK((yp + 1) * 320 + xp)
col = col + PEEK(yp * 320 + (xp + 1))
col = FIX(col / 5 - 1)
IF col < 0 THEN col = 0
POKE yp * 320 + xp, col
fastout1:
NEXT
NEXT
DEF SEG
END SUB

DEFSNG A-Z
SUB GorauFill (points() AS RoutineType)

DIM Scan(0 TO 320) AS GorType

XMax% = -32767
Xmin% = 32767

FOR X% = 0 TO 3
  IF XMax% < points(X%).X THEN XMax% = points(X%).X
  IF Xmin% > points(X%).X THEN Xmin% = points(X%).X
  PSET (points(X%).X, points(X%).Y), 230
NEXT


 IF Xmin% < 0 THEN Xmin% = 0
 IF XMax% > 320 THEN XMax% = 320
 IF Xmin% > 320 THEN EXIT SUB
 IF XMax% < 0 THEN EXIT SUB

FOR X% = Xmin% TO XMax%
  Scan(X%).y1 = -32767
NEXT



FOR X% = 0 TO 3

  Val1% = X%
  Val2% = (X% + 1) MOD 4

    IF points(Val1%).X > points(Val2%).X THEN
      SWAP Val1%, Val2%
    END IF
 
  y1% = points(Val1%).Y
  x1% = points(Val1%).X
  Col1% = points(Val1%).c

  y2% = points(Val2%).Y
  x2% = points(Val2%).X
  Col2% = points(Val2%).c

  YDelta% = y2% - y1%
 
  XDelta% = x2% - x1%
  CDelta% = Col2% - Col1%
 
  IF XDelta% <> 0 THEN
   YSlope! = YDelta% / XDelta%
   CSlope! = CDelta% / XDelta%
  ELSE
   YSlope% = 0
   CSlope% = 0
  END IF

  YVal! = y1%
  CVal! = Col1%
 
      FOR I% = x1% TO x2%
        IF Scan(I%).y1 = -32767 THEN
          Scan(I%).y1 = YVal!
          Scan(I%).C1 = CVal!
        ELSE
          Scan(I%).y2 = YVal!
          Scan(I%).C2 = CVal!
        END IF

        YVal! = YVal! + YSlope!
        CVal! = CVal! + CSlope!
     
      NEXT

NEXT



FOR X% = Xmin% TO XMax%

  IF Scan(X%).y1 > Scan(X%).y2 THEN
    y2% = Scan(X%).y1
    y1% = Scan(X%).y2
    Col2% = Scan(X%).C1
    Col1% = Scan(X%).C2
  ELSE
    y2% = Scan(X%).y2
    y1% = Scan(X%).y1
    Col2% = Scan(X%).C2
    Col1% = Scan(X%).C1
  END IF

  YDelta% = y2% - y1%
 
  IF YDelta% = 0 THEN YDelta% = 1

  CDelta% = Col2% - Col1%
  CSlope! = CDelta% / YDelta%
  CVal! = Col1%

    FOR I% = Scan(X%).y1 TO Scan(X%).y2
      PSET (X%, I%), CVal!
      CVal! = CVal! + CSlope!
    NEXT

NEXT



END SUB

DEFINT A-Z
SUB MakePal STATIC
FOR X = 1 TO 28
Pal X, X * 2, Color2, Color1
P(X, 1) = INT(X * 2.25)
P(X, 2) = Color2
P(X, 3) = Color1
NEXT X

FOR X = 29 TO 56
Pal X, (X - 28) * 2, Color3, Color2
P(X, 1) = INT((X - 28) * 2.25)
P(X, 2) = Color3
P(X, 3) = Color2
NEXT X

FOR X = 57 TO 84
Pal X, (X - 56) * 2, Color4, Color3
P(X, 1) = INT((X - 56) * 2.25)
P(X, 2) = Color4
P(X, 3) = Color3
NEXT X

FOR X = 85 TO 112
Pal X, (X - 84) * 2, Color5, Color4
P(X, 1) = INT((X - 84) * 2.25)
P(X, 2) = Color5
P(X, 3) = Color4
NEXT X

FOR X = 113 TO 140
Pal X, (X - 112) * 2, Color6, Color5
P(X, 1) = INT((X - 112) * 2.25)
P(X, 2) = Color6
P(X, 3) = Color5
NEXT X

FOR X = 141 TO 168
Pal X, (X - 140) * 2, Color7, Color6
P(X, 1) = INT((X - 140) * 2.25)
P(X, 2) = Color7
P(X, 3) = Color6
NEXT X

FOR X = 169 TO 196
Pal X, (X - 168) * 2, Color8, Color7
P(X, 1) = INT((X - 168) * 2.25)
P(X, 2) = Color8
P(X, 3) = Color7
NEXT X

FOR X = 197 TO 224
Pal X, (X - 196) * 2, Color1, Color8
P(X, 1) = INT((X - 196) * 2.25)
P(X, 2) = Color1
P(X, 3) = Color8
NEXT X

'28,56,84,112,140,168,196,224,252
END SUB

DEFSNG A-Z
SUB ModeX
  CALL OutPort(&H3C4, 6, 4): CLS
  CALL OutPort(&H3D4, 227, 23)
  CALL OutPort(&H3D4, 0, 20)
  CALL OutPort(&H3C4, 15, 2)
END SUB

DEFINT A-Z
SUB NewColor STATIC
Color1 = INT(RND * 8) + 1
Color2 = INT(RND * 8) + 1
Color3 = INT(RND * 8) + 1
Color4 = INT(RND * 8) + 1
Color5 = INT(RND * 8) + 1
Color6 = INT(RND * 8) + 1
Color7 = INT(RND * 8) + 1
Color8 = INT(RND * 8) + 1
MakePal
END SUB

DEFSNG A-Z
SUB OutPort (PortAddr&, vh%, vl%)
  OUT PortAddr&, vl%: OUT PortAddr& + 1, vh%
END SUB'<br>

DEFINT A-Z
SUB Pal (PN, I, C1, C2) STATIC
Ri = 0
Gi = 0
Bi = 0
IF C1 = 1 THEN Bi = Bi + I
IF C1 = 2 THEN Gi = Gi + I
IF C1 = 3 THEN Bi = Bi + I: Gi = Gi + I
IF C1 = 4 THEN Ri = Ri + I
IF C1 = 5 THEN Bi = Bi + I: Ri = Ri + I
IF C1 = 6 THEN Ri = Ri + I: Gi = Gi + I
IF C1 = 7 THEN Ri = Ri + I: Gi = Gi + I: Bi = Bi + I
IF C2 = 1 THEN Bi = Bi + 63 - I
IF C2 = 2 THEN Gi = Gi + 63 - I
IF C2 = 3 THEN Bi = Bi + 63 - I: Gi = Gi + 63 - I
IF C2 = 4 THEN Ri = Ri + 63 - I
IF C2 = 5 THEN Bi = Bi + 63 - I: Ri = Ri + 63 - I
IF C2 = 6 THEN Ri = Ri + 63 - I: Gi = Gi + 63 - I
IF C2 = 7 THEN Ri = Ri + 63 - I: Gi = Gi + 63 - I: Bi = Bi + 63 - I
IF Ri > 63 THEN Ri = 63
IF Gi > 63 THEN Gi = 63
IF Gi > 63 THEN Bi = 63
OUT 968, PN
OUT 969, Ri
OUT 969, Gi
OUT 969, Bi
END SUB

DEFSNG A-Z
SUB ReadRGB (red%, grn%, blu%, slot%)
  '
  OUT &H3C7, slot% ' Read RGB values from slot
  '
  red% = INP(&H3C9)
  grn% = INP(&H3C9)
  blu% = INP(&H3C9)
  '
END SUB

DEFINT A-Z
SUB Rotate
'UPDATES all (X,Y,Z) coordinates according to XAngle,YAngle,ZAngle
 
  FOR I = 1 TO Slices
    FOR i2 = 1 TO PPS
                     '{rotate on X-axis}
      TempY = (Ball(I, i2).Y * CosTable(XAngle) - Ball(I, i2).Z * SinTable(XAngle)) / 128
      TempZ = (Ball(I, i2).Y * SinTable(XAngle) + Ball(I, i2).Z * CosTable(XAngle)) / 128
                    ' {rotate on y-anis}
      TempX = (Ball(I, i2).X * CosTable(YAngle) - TempZ * SinTable(YAngle)) / 128
      TempZ = (Ball(I, i2).X * SinTable(YAngle) + TempZ * CosTable(YAngle)) / 128
                     '{rotate on z-axis}
      OldTempX = TempX
      TempX = (TempX * CosTable(ZAngle) - TempY * SinTable(ZAngle)) / 128
      TempY = (OldTempX * SinTable(ZAngle) + TempY * CosTable(ZAngle)) / 128
      points(I, i2).X = (TempX * Scale) / Distance + 320 / 2
      points(I, i2).Y = (TempY * Scale) / Distance + 200 / 2
      points(I, i2).Z = TempZ
    NEXT i2
  NEXT I
END SUB

SUB SetPal (start.slot%, end.slot%)
  '
  num.slots% = end.slot% - start.slot%
  '
  CALL ReadRGB(sr%, sg%, sb%, start.slot%)
  CALL ReadRGB(er%, eg%, eb%, end.slot%)
  '
  rr% = ABS(er% - sr%): rg% = ABS(eg% - sg%): rb% = ABS(eb% - sb%)
  rs% = SGN(er% - sr%): gs% = SGN(eg% - sg%): bs% = SGN(eb% - sb%)
  '
  stepr = (rr% / num.slots%) * rs%
  stepg = (rg% / num.slots%) * gs%
  stepb = (rb% / num.slots%) * bs%
  '
  r = sr%: g = sg%: B = sb%
  wr% = r: wg% = g: wb% = B
  '
  FOR t% = start.slot% TO end.slot%
    '
    CALL WriteRGB(wr%, wg%, wb%, t%)
    '
    r = r + stepr: wr% = r
    g = g + stepg: wg% = g
    B = B + stepb: wb% = B
    '
  NEXT t%
  '
END SUB

'{sets up the ball's data..}
SUB SetupBall ' {set up the points}
  FOR SliceLoop = 1 TO Slices
      Phi! = pi / Slices * SliceLoop        ' 0 <= Phi <= Pi
      FOR PPSLoop = 1 TO PPS
          theta! = 2 * pi / PPS * PPSLoop   ' 0 <= Theta <= 2*Pi
              '{convert Radius,Thetha,Phi to (x,y,z) coordinates}
          Ball(SliceLoop, PPSLoop).Y = INT(Radius * SIN(Phi!) * COS(theta!))
          Ball(SliceLoop, PPSLoop).X = INT(Radius * SIN(Phi!) * SIN(theta!))
          Ball(SliceLoop, PPSLoop).Z = INT(Radius * COS(Phi!))
      NEXT PPSLoop
 NEXT SliceLoop
END SUB

DEFSNG A-Z
SUB SetVOffset (offset&)
  v& = offset&
  CALL OutPort(&H3D4, v& \ 256, 12)
  CALL OutPort(&H3D4, v& AND 255, 13)
END SUB'<br>

SUB Standard
  CALL OutPort(&H3C4, 14, 4)
  CALL OutPort(&H3D4, 163, &H17)
  CALL OutPort(&H3D4, 64, &H14)
  CALL OutPort(&H3C4, 15, &H2)
END SUB

DEFINT A-Z
SUB teletype (Text$, delayt)

    DIM melt%(10000)
    d! = delayt

'   if no delay, assign default
    IF d! < 1 THEN
       d! = 5
    END IF

'   change delay to 100ths second
    d! = d! / 100

'   print text 1 char at a time, with a "click" after non-space characters

    FOR X% = 1 TO LEN(Text$)

        t$ = MID$(Text$, X%, 1)
        PRINT t$;
        IF t$ <> " " THEN
           SOUND 32000, 1
        END IF
        FOR I% = 1 TO 5
         RANDOMIZE TIMER
         XX = INT(RND * 279)
         RANDOMIZE TIMER
         YX = INT(RND * 20)
         GET (XX, YX)-(XX + 48, YX + 48), melt%
         PUT (XX, YX + 1), melt%, PSET
        NEXT I%
     
        '       get current value of TIMER
        CurrentTimer! = TIMER

'       delay appropriate time
        WHILE TIMER < (CurrentTimer! + d!)
        WEND

'       stop delaying if a key is pressed
        IF INKEY$ <> "" THEN
           d! = 0
        END IF
    NEXT X%

END SUB

SUB TestPal STATIC

FOR X = 1 TO 224

FOR Y = 1 TO 200
PSET (X, Y), X
NEXT Y
NEXT X
END SUB

DEFSNG A-Z
FUNCTION ValidPolPoints

' This polygons must be convex in order for this to work properly, so this
' generates one point within each quarter of the screen, which might give
' one the incorrect impression that this routine is somewhat limited.

FOR I% = 0 TO 3
 
  SELECT CASE I%
    CASE 0:
           PolPoints(0).X = INT(RND * 60) + 1
           PolPoints(0).Y = INT(RND * 60) + 1
    CASE 1:
           PolPoints(1).X = INT(RND * 160) + 160
           PolPoints(1).Y = INT(RND * 100) + 2
'           IF PolPoints(1).Y < PolPoints(0).Y THEN PolPoints(1).Y = PolPoints(0).Y + INT(RND * (100 - PolPoints(0).Y))
    CASE 2:
           PolPoints(2).X = INT(RND * 160) + 160
'           IF PolPoints(2).X < PolPoints(1).X THEN PolPoints(2).X = PolPoints(1).X + 1
           PolPoints(2).Y = INT(RND * 50) + 150
    CASE 3:
           PolPoints(3).X = INT(RND * 160) + 1
           IF PolPoints(3).X < PolPoints(0).X THEN PolPoints(3).X = PolPoints(0).X + INT(RND * (160 - PolPoints(0).X))
           PolPoints(3).Y = INT(RND * 100) + 100
'           IF PolPoints(3).Y < PolPoints(2).Y THEN PolPoints(3).Y = PolPoints(2).Y + INT(RND * (100 - PolPoints(2).Y))
  END SELECT

 PolPoints(I%).c = -1

NEXT

 
' Make one corner black and one corner the brightest color; the other 2 random
  
   DO UNTIL BlackOne% <> BrightOne%
     BlackOne% = INT(RND * 3)
     BrightOne% = INT(RND * 3)
   LOOP

  PolPoints(BlackOne%).c = 0
  PolPoints(BrightOne%).c = 230

  FOR I% = 0 TO 3
   IF PolPoints(I%).c = -1 THEN PolPoints(I%).c = INT(RND * 230) + 1
  NEXT

END FUNCTION

DEFINT A-Z
SUB word (seki$, Y, X)
kmax = LEN(seki$)
FOR cl = 20 TO 29
FOR lag = 1 TO delayt / 15: NEXT lag
FOR k = 1 TO kmax
psent$ = MID$(seki$, k, 1)
COLOR cl: LOCATE Y, X + k: PRINT psent$
NEXT
NEXT
END SUB

SUB WriteRGB (red%, grn%, blu%, slot%)
  '
  OUT &H3C8, slot% ' Write RGB values to slot
  '
  OUT &H3C9, red%
  OUT &H3C9, grn%
  OUT &H3C9, blu%
  '
END SUB

