 ;""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""";
 ;  tinySORT for the 5th HUGI competition :)  --  by Jibz / q!p '98  ;
 ;                                                                   ;
 ;   - Read the data and collect pointers to each line (adding '$')  ;
 ;   - Bubble-sort these pointers and print sorted lines             ;
 ;...................................................................;

.model tiny
.486
locals
jumps
codeseg
org 100h

start:

;=====================================================================
;   read file into buffer and create list of string pointers
;=====================================================================
    xchg    ax, cx                  ; cx = 0, since no command line
    mov     bh, 10h                 ; bx = 1000h
    mov     ax, cs
    add     ax, bx                  ; ax = es + 1000h
    mov     es, ax
    xor     di, di
    push    bx                      ; save offset to ptr table

newline:
    mov     al, '$'                 ; add a '$' to each line
    stosb
    inc     cx
    mov     [bx], di                ; save ptr to string in table
    inc     bx
    inc     bx
more:
    cmp     al, 0ah                 ; newline?
    je      newline
    mov     ah, 06h
    mov     dl, 0ffh
    int     21h                     ; get a char from stdin
    stosb
    jnz     more

    dec     cx
    pop     di

;=====================================================================
;   bubble-sort string pointers and output along the way
;=====================================================================
outerloop:
    pusha
    mov     si, di
cmploop:
    lodsw

    pusha
    xchg    ax, di
    mov     si, [si]
    mov     cx, sp                  ; cx = sp = something big
    db      0f3h, 026h, 0a6h        ; rep es:cmpsb
    popa

    jbe     notyet
    xchg    ax, [si]
notyet:
    mov     [di], ax
    inc     di
    inc     di
    loop    cmploop

    mov     dx, [si-2]
    mov     ah,9
    push    ds
    push    es
    pop     ds
    int     21h                     ; print out line
    pop     ds
    popa
    loop    outerloop

    ret

end start
