;---------------------------------------------------------------
; line sort program (46 bytes) by Picard/Rhyme 
; http://rhyme.scene-hu.com
; mailto:picard@scene-hu.com
;---------------------------------------------------------------
; the main idea is that i use the previous  line's last 0Ah char
; as a mark. because 0Ah is the smallest char, i can search char 
; by char for the minimal line. when found, i just increase this 
; mark (0Ah->0Bh), this way all other lines preceded by 0Ah will
; come ahead  of this line  at the  next line  search. after all
; line printed, there  is no  more 0Ah left, and the min. search 
; will  find  a line  with 0Bh. when  this happens  the  program 
; terminates. ( after increase: 0Bh parity=0, but 0Ch parity=1 )
; when printing a line, i can't  be sure  if it ends with 0Ah or
; 0Bh (depends if the next line has been printed or not). that's
; why i stop at 0Dh, and reuse the first int21h to print 0Ah.
;---------------------------------------------------------------
; assumed values:
;  bx = 0
;  dx = cs
;  si = 100h
;  01FFh < cs < 8B00h
;  d flag = 0
;  c flag = 0
;  int21h/02h returns the printed char in AL
;---------------------------------------------------------------
.model tiny
.386
.code
.startup
                                        ; initial [si] > 0Ah
                mov     ah,3Fh          ; dosint read function 
Exit:           mov     ch,0C3h         ; cx > 30000 & hidden 'ret' inst.
LineLoop:       mov     dl,0Ah          ; dx = (cs & 0FF00h) + 0Ah
                int     21h             ; first time: read input
                mov     di,dx           ; later: print 0Ah char
                dec     di              ; di = dx-1
                jc      NotRead         ; only first time: 
                mov     [di],dl         ;   put 0Ah char before first line
                xchg    bx,ax           ;   bx = input text length
NotRead:        mov     cx,bx           ; search smallest line
CharLoop:       pusha                            
                repz    cmpsb           ; cx is big enough 
                popa
                jb      NoChange        ; if string is smaller 
                mov     si,di           ;   si = di
NoChange:       inc     di              ; check byte by byte
                loop    CharLoop        ; until no more left (very last 0Ah not checked!)
                inc     byte ptr [si]   ; mark line 0Ah->0Bh
                jp      Exit+1          ; when line already marked (0Bh->0Ch) exit
PutChar:        inc     si              ; next char
                mov     ah,02h          ; dosint print char to stdout 
                mov     dl,[si]         
                int     21h
                cmp     al,14           ; when printed char < 14, stop print
                jnc     PutChar         ;   [si] will be always 13 and
                jmp     LineLoop        ;   c flag always 1
end