; NIB.COM   by Chess Knight
; This program is a very short implementation of a snake game.
; Created for size optimized code contest at
;   http://home.pages.de/~hugi-compo
; Keys 2,4,6 and 8 control the direction of the snake, so
;   Num Lock must be on if using the numeric keypad.
; Other keys cause wild behavior (but won't crash program).
; Must press any direction quickly or snake hits wall and program ends.
;
;  Assembled with Turbo Assembler V3.1
;    tasm /m read
;    tlink /t read
;  /m enables multiple passes so that jumps are optimized
;  /t tells the linker to make a COM file.
;
;------------------------------------
;
DTOFF            EQU     -6
_TEXT   SEGMENT WORD PUBLIC 'CODE'
        ORG     100H
_SEEFILE PROC    FAR                             ;define far proc
        ASSUME  CS:_TEXT,DS:_TEXT
;
;       initialize stack and load segment registers
;
; Change to 320x200x256 video
        MOV     AL,013H         ;Assume AH=0 at start of program
        INT     10H
        STD
; initialize registers that never change or don't change until main loop
        MOV     SI,318
        mov     dx,3dah
; draw border
        LES     DI,[SI+DTOFF+6]
        MOV     CX,2177         ;65536-320*200+642 (pixels to fill)
        REP     ;STOSB           ;draw bottom and top
J10:
        STOSB                   ;draw right side
        STOSB                   ;draw left side
        SUB     DI,SI
        JNZ     J10

;---------------------------------------------------
; main loop
;            BX = direction (start value of 0 is not valid)
;            DI = screen position (starts near center of top row)
;           (SI is within 128 of offset DIRTAB, CX = 0)
J100:
        XCHG    BX,AX

        SUB     DI,[BX+SI-(032H-DTOFF)]      ;update position
; vertical retrace delay loop
delay_l1:
        in      al,dx
        AND     al,8
        OR      CL,AL
        XOR     AL,CL
        je      delay_l1

        MOV     AH,1
J200:
        XOR     BH,BH           ;Must use XOR to set Z flag (else could
do CBW)
        INT     16H             ;Get keypress (scan or clear, depending
on AH)
        XCHG    BX,AX
        JNZ     J200

        XCHG    ES:[DI],CL      ;draw pixel and get original color at
same time
        JCXZ    J100            ;test original color

;------------------------------------------------------
; EXIT PROGRAM
; change to 80x25 color text
        MOV     AL,03H          ;AH=0
        INT     10H
;  terminate
        INT     20H
_SEEFILE ENDP
;======================================================
; data
DIRTAB  DW      -320, 1, -1, 320
        DW      0A000H
        ;68 byte version used 320*200-65536-320-1 (start of bottom row).
        ;66 byte version sets direction flag (STD) and starts at end of
top row
        ;  which is at 320, which is the same as the offset to SUBtract
        ;  when moving up (8 key) so 4 bytes of data are reduced to 2.
_TEXT   ENDS
        END     _SEEFILE