                .model tiny
                .code
                .386

COMMENT %

  Small Nibbles program for Hugi size compo

  No support, no warranties.

  This program might considered violating the rules :
  1. In some cases the snake gets color black. In fact, the snake
     is colored in color 255 - whatever color this color on your system
     is (NT switches it to white on my machine ;-) ).
  2. The player must start the game by pressing "6".


  Give credit where it's due,
  Corion, April 1998                         corion@informatik.uni-frankfurt.de
        %

DEBUG equ 1

                org 0100h
main            proc near
start:
                ; AH = 0
                mov     al, 13h
                int     10h                             ; Set video mode
                ; Direction flag clear !

                IF DEBUG
                ; 16 bytes unnecessary startup code

                ; Read one keystroke (keypad 6)
                xor     ax, ax
                int     16h
                xor     ax, ax

                ; Make snake white colored
                mov     dx, 03C8h
                mov     al, -3
                out     dx, al
                inc     dx
                out     dx, al
                out     dx, al
                out     dx, al

                ENDIF

                ; Setup ES to screen
                push    0A000h
                pop     es

                ; 16 bytes for frame setup
                ; Set up left/right border
                ; DI = ????
                xor     di, di

                ; CH = 0
                ; AL = 13h
                mov     cl, 199
NextLine:
                stosb
                add     di, 318
                stosb
                loop    NextLine

                ; Draw lower border and wrap around to the first border
                mov     cx, 320 + 1536 + 320
                rep     stosb

                ; CX = 0
                ; BX = 0
GameLoop:
                ; Main loop of the game

                ; Read the key
                in      al, 60h
                ;al=48h    UpArrow         = 01001000
                ;al=4Bh    LeftArrow       = 01001011
                ;al=4Dh    RightArrow      = 01001101
                ;al=50h    DownArrow       = 01010000

                and     al, 3Fh
                ;al=18h    UpArrow         = 00001000
                ;al=1Bh    LeftArrow       = 00001011
                ;al=1Dh    RightArrow      = 00001101
                ;al=20h    DownArrow       = 00010000

                sub     al, 0Ch
                ;al=18h    UpArrow         = 11111100
                ;al=1Bh    LeftArrow       = 11111111
                ;al=1Dh    RightArrow      = 00000001
                ;al=20h    DownArrow       = 00000100

                ; Sign expand al to ax
                cbw

                test    al, 1
                jnz     LeftRight

                ; +4/-4 -> +320/-320
                imul    ax, 50h
LeftRight:
                add     di, ax

                ; V-Retrace wait
                ; BX = 0
                mov     ah, 0Bh
                int     10h

                ; Collision check & pixel paint
                mov     ax, 03h

                sub     byte ptr es:[di], al
                jc      GameLoop                        ; Check for underflow

GameOver:
                ; Was no underflow - so it
                ; must have been a collision
                ; since only black (0) pixels
                ; are allowed to be entered

                ; AX = 3
                int     10h                             ; Set video mode
                ret                                     ; Terminate

                endp

END main
COMMENT %
HISTORY:
84 bytes        First running version - has problems with the dec/jnc collision
                check. Otherwise looks good. Still 24 bytes to go.
82 bytes        After some initial optimizations. The direction handling (12
                bytes) worries me, as does the 10 byte retrace wait.
75 bytes        Now you have to (very fast) press "6" to get the game going.
                Input is now handled by DOS instead of BIOS
74 bytes        Removed cbw and placed the constant in the table.
72 bytes        Changed loop logic so it only uses one jump to determine
                if to loop again.
69 bytes        Radical change. Now reading keys using port 60h, no more
                add tables.
66 bytes        Made some calculations 8 bit instead of 16 bit.
65 bytes        Now the color of the snake isn't even visible anymore under NT...
                But it is _not_ the background color ;-)
61 bytes        Removed the old vertical retrace code to use INT10/0Bh
                That's a nasty trick, but it works !
59 bytes        Removed even more obsolete setup code
56 bytes        Now it's using INT10/0Bh/BX=00h
%
