/* music.c - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <mikmod.h>
#include "modplay.h"
#include "file.h"

MODULE* module = NULL;

int init( struct music* m )
{
    md_mode = DMODE_SOFT_MUSIC | DMODE_16BITS | DMODE_STEREO;
    md_reverb = 0;
    
    MikMod_RegisterAllDrivers();
    MikMod_RegisterAllLoaders();

#if LIBMIKMOD_VERSION >= 0x030107    
    if(MikMod_Init("")) {
#else
    if(MikMod_Init()) {
#endif
        printf("mikmod: could not initialize sound, reason: %s\n",
                MikMod_strerror(MikMod_errno));
        return 1;
    }
    return 0;
}

int load( struct music* m, char* path, char* filename )
{
    module = Player_Load( data_file(path, filename) ,64,0);
    if (!module) {
        printf("mikmod: could not load module, reason: %s\n",
                MikMod_strerror(MikMod_errno));
        return 1;
     }
    return 0;
}

void done( struct music* m )
{
    MikMod_Exit();
}

void start( struct music* m )
{
    Player_Start(module);
}

void stop( struct music* m )
{
    Player_Stop();
    Player_Free(module);
}

void update( struct music* m )
{
    MikMod_Update();
}

void set_volume ( struct music* m, int volume )
{
    Player_SetVolume ( volume );
}

void set_pattern ( struct music* m, int pattern )
{
    Player_SetPosition ( pattern );
}

