/* graphics.h - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __GRAPHICS_H
#define __GRAPHICS_H

#include "image.h"
#include "font.h"
#include "config.h"
#include "scroller.h"

struct graphics {
    struct font writerFont;
    struct font scrollerFont;
    
    struct image creditsImage;
    struct image titleImage;
    
    struct image logoImage;
    struct image backgroundImage;
    struct image textframeImage;
    
    struct image endImage;

    struct scroller scroll;
};

#define IMAGEFILE_CREDITS    "credits.png"
#define IMAGEFILE_FONT       "font.png"
#define IMAGEFILE_TITLE      "title.png"
#define IMAGEFILE_LOGO       "logo.png"
#define IMAGEFILE_BACKGROUND "background.png"
#define IMAGEFILE_TEXTFRAME  "textframe.png"
#define IMAGEFILE_ENDIMAGE   "endlogo.png"

int loadGraphics( char* datapath, struct graphics* g );
int initGraphics( struct graphics* g, struct screen* s );
void doneGraphics( struct graphics* g );

#endif /* __GRAPHICS_H */

