/* image.c - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>
#include <png.h>
#include "image.h"

void pngError()
{
}

void pngWarning()
{
}

int loadImage( struct image* i, char* fn )
{
   png_structp png_ptr;
   png_infop info_ptr;
   unsigned int sig_read = 0;
   png_uint_32 width, height;
   int bit_depth, color_type, interlace_type;
   FILE *fp;
   int row, col;
   png_bytep src;
   uint8* dest;
   int size;
   int num_palette;
   png_color *palette;
   int color;

   png_voidp user_error_ptr = NULL;
   png_bytep *row_pointers;

   if ((fp = fopen(fn, "rb")) == NULL)
      return 1;

   png_ptr = png_create_read_struct( PNG_LIBPNG_VER_STRING,
                                     user_error_ptr,
                                     pngError, pngWarning);
   if (png_ptr == NULL)
   {
      fclose(fp);
      return 1;
   }
   
   info_ptr = png_create_info_struct(png_ptr);
   if (info_ptr == NULL)
   {
      fclose(fp);
      png_destroy_read_struct(&png_ptr, (png_infopp)NULL, (png_infopp)NULL);
      return 1;
   }

   if (setjmp(png_ptr->jmpbuf))
   {
      png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
      fclose(fp);

      return 1;
   }

   png_init_io(png_ptr, fp);
   png_set_sig_bytes(png_ptr, sig_read);

   png_read_info(png_ptr, info_ptr);
   png_get_IHDR(png_ptr, info_ptr, &width, &height, &bit_depth, &color_type,
       &interlace_type, NULL, NULL);

   row_pointers = malloc( height * sizeof(row_pointers) );
   for (row = 0; row < height; row++)
   {
       size = png_get_rowbytes(png_ptr, info_ptr);
       row_pointers[row] = (png_bytep) malloc(size);
       if (row_pointers[row] == NULL) {
           printf("pngloader: could not allocate memory\n");
           return -1;
       }
   }

   png_read_image(png_ptr, row_pointers);

           /* put read data in a 8bpp buffer */

   i->width = width;
   i->height = height;

   i->buffer = (uint8*) malloc( width * height * 1 );
   if (!i->buffer) {
       printf("pngloader: could not get memory for image\n");
       return 1;
   }

   dest = i->buffer;
   for (row = 0; row < height; row++)
   {
       src = row_pointers[row];
       for (col = 0; col < width; col++)
       {
           *dest++ = *src++;
       }
   }

   for (row = 0; row < height; row++)
   {
       free(row_pointers[row]);
   }
   free(row_pointers);

   palette = (png_color*) malloc(256 * sizeof(png_color*));

   num_palette = 256;
   png_get_PLTE(png_ptr, info_ptr, &palette, &num_palette);

   for ( color = 0; color < 256; color++ )
   {
       i->palette[color].r = (palette[color].red >> 2) << 10;
       i->palette[color].g = (palette[color].green >> 2) << 10;
       i->palette[color].b = (palette[color].blue >> 2) << 10;
   }

   png_read_end(png_ptr, info_ptr);
   png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);

   fclose(fp);

   return 0;
}

void freeImage( struct image* i )
{
    free(i->buffer);
}

void drawImage( struct image* i, uint32 destx, uint32 desty, uint32 destwidth, uint32 destheight, uint32 srcx, uint32 srcy )
{
    int row;
    uint8* from;
    uint8* to;

    to = i->dest->buffer + destx + desty * i->dest->width;
    from = i->buffer + srcx + srcy * i->width;

    for ( row = 0; row < destheight; row++ )
    {
        memcpy( to, from, destwidth); 
        to += i->dest->width; 
        from += i->width;
    }
}

void drawTransparentImage( struct image* i, uint32 destx, uint32 desty, uint32 destwidth, uint32 destheight, uint32 srcx, uint32 srcy )
{
    int row,col;
    uint8* from;
    uint8* to;
    uint8 c;

    to = i->dest->buffer + destx + desty * i->dest->width;
    from = i->buffer + srcx + srcy * i->width;

    for ( row = 0; row < destheight; row++ )
    {
        for (col = 0; col < destwidth; col++ )
        {
            c = *(from+col);
            if (c)
                *(to+col) = c;
        }
        to += i->dest->width; 
        from += i->width;
    }
}

void image_clear_part( struct image* i, uint32 destx, uint32 desty, uint32 w, uint32 h )
{
    uint8* dest;
    uint32 x,y;
    
    dest = i->dest->buffer + destx + desty * i->dest->width;
    
    for ( y = 0; y < h; y++)
    {
        for ( x = 0; x < w; x++)
        {
            *(dest+x) = 0;
        }
        dest += i->dest->width;
    }
}

