/* image.h - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __IMAGE_H
#define __IMAGE_H

#include "types.h"

struct color {
    uint32 r;
    uint32 g;
    uint32 b;
};

struct image {
    uint32 width,height;
    uint8* buffer;
    struct image* dest;
    struct color palette[256];
};

int loadImage( struct image* i, char* fn );
void freeImage( struct image* i );
void drawImage( struct image* i, uint32 destx, uint32 desty, uint32 destwidth, uint32 destheight, uint32 srcx, uint32 srcy );
void image_clear_part( struct image* i, uint32 destx, uint32 desty, uint32 w, uint32 h );

#endif /* __IMAGE_H */
