/* screen.h - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __SCREEN_H
#define __SCREEN_H

#include "types.h"
#include "image.h"
#include "video.h"

#define SCR_WIDTH      320
#define SCR_HEIGHT     200
#define SCR_BPP        8
#define SCR_REFRESH_RATE 70

struct palette_color {
    uint32 r;
    uint32 g;
    uint32 b;
};

#define SCREEN_TARGET_LIBGGI   ( 1<<0 )
#define SCREEN_TARGET_X11      ( 1<<1 )
#define SCREEN_TARGET_SVGALIB  ( 1<<2 ) 

struct screen {
    int preferred_target; /* this should be a combination of some of
                             SCREEN_TARGET_LIBGGI, SCREEN_TARGET_X11,
                             SCREEN_TARGET_SVGALIB to assist in picking a target
                             automatically */
    
    struct video_driver driver;
    struct image* image;
    
    int directBuffered;
    
    struct color colormap[256];
    
    int zoom_factor; /* number of times each pixel is scaled */
    
    int wait_retrace; /* if set to 1 then active vertical retrace polling is done..
                         this will however probably only work with svgalib */
    
    
    uint8* dummyZoomLineBuffer; /* this internal buffer is used to speed up zooming */

    int paletteDirty; /* this internal flag is set if the palette needs updating
                         for the next frame */
};

int screen_init ( struct screen* s, char* so_path );
void screen_set_color ( struct screen* s, uint8 color, sint32 r, sint32 g, sint32 b );
void screen_clear ( struct screen* s );
void screen_fade ( struct screen* s, struct palette_color* to, float perunage);

#endif /* __SCREEN_H */
