/* text.c - read text files 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "text.h"
#include "file.h"

char rot13 ( char c )
{
    if ( ( c >= 'a' ) && ( c <= 'z' ) )
    {
        if ( c <= 'z'-13 )
            c += 13;
        else
            c += 13-26;
    }
    if ( ( c >= 'A' ) && ( c <= 'Z' ) )
    {
        if ( c <= 'Z'-13 )
            c += 13;
        else
            c += 13-26;
    }
    return c;
}

int loadScrollText( char* datapath, char* scrollText, int n )
{
    FILE* f;
    int i;
    char c;

    f = fopen( data_file(datapath,TEXT_SCROLLFILE), "r" );
    if ( f == NULL )
        return -1;

    i = 0;
    do {
        c = fgetc(f);
        if (c == EOF)
        {
            scrollText[i++] = '\0';
            return i;
        }
        
        scrollText[i++] = rot13(c);
    } while (i < n);

    return i;
}

int loadWriterText( char* datapath, struct text* t )
{
    FILE* f;
    int p; /* page number */
    char* r; /* return value of fgets */
    int length, line;
    char str[TEXT_MAXLINESIZE+1];
    int i;

    f = fopen( data_file(datapath,TEXT_WRITERFILE), "r" );
    if ( f == NULL )
        return 1;

    p = 0;
    line = 0;
    
    do {
        r = fgets( str, TEXT_MAXLINESIZE, f );

        switch (str[0]) {
                case '_':                             /* page break */
                    t->writerText[p].lines = line;
                        
                    p++;
                    line = 0;
                    
                    break;
                    
                case '#':                             /* comment */
                    break;
                    
                default:
                    length = strlen(str);
                    str[ length - 1 ] = '\0';

                    for ( i = 0; i < TEXT_COLS; i++ )
                    {
                        if ( str[i] == '\0' )
                            break;

                        t->writerText[p].buffer[line][i] = rot13 ( str[i] );
                    }
                    t->writerText[p].cols[line] = length - 1;

                    line++;

                    break;
        }    
    } while (r != NULL);

    t->pages = p;
    fclose(f);
    return 0;
}
