/* framecount.h - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __FRAMECOUNT_H
#define __FRAMECOUNT_H

#include <sys/time.h>
#include <unistd.h>

#define DONT_IDLE_WAIT_FOR_TIMER

struct frame_count {
    double rate;
    struct timeval t0;
    double frame;
};

void init_frame_counter ( struct frame_count* fc, double r );

/* set the framerate in frames/second */
void set_frame_rate ( struct frame_count* fc , double freq );

void reset_frame_counter ( struct frame_count* fc );

/* suspend until the next frame is active
   returns the number of frames since last reset_frame_counter() */
double wait_next_frame ( struct frame_count* fc );

/* updates the current framecounter
   returns the number of frames since last reset_frame_counter() */
double update_frame_counter ( struct frame_count* fc );

/* returns the number of frames since last reset_frame_counter() */
double get_frame_counter ( struct frame_count* fc );

void inc_frame_counter ( struct frame_count* fc );

#endif /* __FRAMECOUNT_H */
