/* modplay.h - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __MODPLAY_H
#define __MODPLAY_H

struct music;

struct modplay_driver {
    int (*load) ( struct music* m, char* path, char* filename );
    int (*init) ( struct music* m );
    void (*done) ( struct music* m );
    void (*update) ( struct music* m );
    void (*start) ( struct music* m );
    void (*stop) ( struct music* m );
    void (*set_volume) ( struct music* m, int volume );
    void (*set_pattern) ( struct music* m, int pattern );
};

struct music {
    int disfunctional;
    struct modplay_driver driver;
};

/* returns 0 on success */
int modplay_register ( struct music* m, char* so_path );

int modplay_init ( struct music* m );
void modplay_done ( struct music* m );
int modplay_load ( struct music* m, char* path, char* filename );
void modplay_update ( struct music* m );
void modplay_start ( struct music* m );
void modplay_stop ( struct music* m );
void modplay_set_volume ( struct music* m, int volume );
void modplay_set_pattern ( struct music* m, int pattern );

#endif /* __MODPLAY_H */
