/* scroller.h - 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __SCROLLER_H
#define __SCROLLER_H

#include "image.h"
#include "screen.h"
#include "font.h"
#include "framecount.h"

#define SCROLL_MAXLENGTH 16384

#define SCROLL_WRAP 350
#define SCROLL_WIDTH 392
#define SCROLL_HEIGHT 20

struct scroller {
    struct image* dest;
    struct font* font;
    struct frame_count fc;

    char* txt;
    int txt_length;
};

int initScroller(struct scroller* s, struct screen* screen );
int loadScroller(char* datapath, struct scroller* s);
void updateScroller(struct scroller* s, double frame);
void scroller_reset ( struct scroller* s );

#endif /* __SCROLLER_H */
