/* text.h - 
   Copyright (C) 1999 .
    <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __TEXT_H
#define __TEXT_H

#include "config.h"

#define TEXT_WRITERFILE "writer.txt"
#define TEXT_SCROLLFILE "scroller.txt"

#define TEXT_MAXPAGES 128
#define TEXT_COLS  28
#define TEXT_LINES 16

#define TEXT_MAXLINESIZE 1024

struct writerTextPage {
    int lines; /* number of lines of text on this page */
    char buffer[TEXT_LINES][TEXT_COLS]; /* an array of the lines of text */
    int cols[TEXT_LINES]; /* the lengths in characters of each line */
};

struct text {
    struct writerTextPage writerText[TEXT_MAXPAGES]; /* contents of the pages */
    int pages;
};

/* read pages of text */
int loadWriterText( char* datapath, struct text* t );

/* Read maximum of n bytes of scrolltext into
   'scrollText' (which should be big enough to hold the data).
   Returns length of read text or -1 on error */
int loadScrollText( char* datapath, char* scrollText, int n );

#endif /* __TEXT_H */





