/* ggi.c - libggi support for the invtro 
   Copyright (C) 1999 Tijs van Bakel.
   Tijs van Bakel <smoke@casema.net>, 
 
 This file is part of the bizarre99 linux invitation intro.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "config.h"

#define PLUGIN_NAME "invtro, libggi-plugin: "

#include <stdlib.h>
#include <unistd.h>

#include <ggi/ggi.h>

#ifdef HAVE_GGI_MISC_H
#include <ggi/misc.h>
#endif

#include "screen.h"

ggi_visual_t visual = NULL;

int init ( struct screen* s )
{
    if (ggiInit() != 0)
    {
        fprintf ( stderr, PLUGIN_NAME "cannot init libggi\n");
        return -1;
    }

    s->image = malloc ( sizeof (struct image) );
    if (!s->image) {
        fprintf ( stderr, PLUGIN_NAME "could not get memory for screen\n");
        return 1;
    }
    
    s->image->width = SCR_WIDTH;
    s->image->height = SCR_HEIGHT;

    s->image->buffer = (uint8*) malloc( SCR_WIDTH * SCR_HEIGHT );
    if (!s->image->buffer) {
        fprintf( stderr, PLUGIN_NAME "could not get memory for screen\n");
        return 1;
    }
    
    visual = ggiOpen(NULL);

    if (visual == NULL)
    {
        fprintf ( stderr, PLUGIN_NAME "could not open default visual\n");
        return -1;
    }
   
    return 0;
}

int set_mode ( struct screen* s, uint32 width, uint32 height, uint32 bpp )
{
    if (ggiSetGraphMode(visual,
                        SCR_WIDTH * s->zoom_factor,SCR_HEIGHT * s->zoom_factor,
                        SCR_WIDTH * s->zoom_factor ,SCR_HEIGHT * s->zoom_factor,
                        GT_8BIT) != 0)
    {
        fprintf ( stderr, PLUGIN_NAME "read the README for frequent problems with libggi\n" );
        return -1;
    }

    ggiSetFlags( visual, GGIFLAG_ASYNC );

#ifdef HAVE_GGI_MISC_H
    if (ggiMiscInit() != 0)
    {
        fprintf ( stderr, PLUGIN_NAME "could not initialize misc extension\n" );
        return -1;
    }
    
    if (ggiMiscAttach(visual) < 0)
    {
        fprintf ( stderr, PLUGIN_NAME "could not attach misc extension\n" );
        return -1;
    }
#endif
    
    return 0;
}

void done ( struct screen* s )
{
    ggiClose( visual );
    ggiExit();
}

void zoomScreen(struct screen *s)
{
    uint8* dest, * src;
    uint32 x,y;
    uint8 pixel;
    uint32 width;
    int i;
    int zoom = s->zoom_factor;

    width = s->image->width * s->zoom_factor;
    src = s->image->buffer;
    
    for (y=0; y < s->image->height; y++)
    {
        dest = s->dummyZoomLineBuffer;
        for (x=0; x < s->image->width; x++)
        {
            pixel = *src++;
            for (i = zoom; i--; )
                *dest++ = pixel;
        }
        for (i=0; i < s->zoom_factor; i++)
            ggiPutHLine( visual, 0, y*s->zoom_factor+i, width, s->dummyZoomLineBuffer );
    }
}

void update_buffer ( struct screen* s )
{
#ifdef HAVE_GGI_MISC_H
    sint32 ggi_rp_x, ggi_rp_y;

    ggi_rp_x = GGI_RP_DONTCARE;
    ggi_rp_y = GGI_RP_SYNC;
#endif
    
    if (! s->directBuffered ) {

#ifdef HAVE_GGI_MISC_H
        if ( s->wait_retrace )
            ggiWaitRayPos ( visual, &ggi_rp_x, &ggi_rp_y );
#endif

        if ( s->zoom_factor != 1 )
        {
            zoomScreen( s );
        }
        else 
        {
            ggiPutBox( visual, 0, 0, SCR_WIDTH, SCR_HEIGHT, s->image->buffer );
        }

        ggiFlush( visual );
    }
}

void update_palette ( struct screen* s, uint32 begincolor, uint32 length )
{
    ggi_color ggimap[256];
    int i;
    
    if ( s->paletteDirty ) {
        for (i = begincolor; i < begincolor+length; i++)
        {
            ggimap[i].r = s->colormap[i].r;
            ggimap[i].g = s->colormap[i].g;
            ggimap[i].b = s->colormap[i].b;
        }

        ggiSetPalette( visual, begincolor, length, &(ggimap[begincolor]) );
        s->paletteDirty = 0;
    }
}

int poll_input ( struct screen* s )
{
    struct timeval t = { 0, 0 };
    ggi_event_mask evmask;
    ggi_event ev;

    evmask = (ggi_event_mask) (emKey);
    
    while (ggiEventPoll( visual, evmask, &t )) {
        ggiEventRead( visual, &ev, evmask );
        switch (ev.any.type) {
                case evKeyPress:
                    switch(ev.key.sym) {
                            case GIIK_Left:
                                return INPUT_LEFT;
                            case GIIK_Right:
                                return INPUT_RIGHT;
                            case GIIK_Up:
                                return INPUT_UP;
                            case GIIK_Down:
                                return INPUT_DOWN;
                            case GIIUC_Escape:
                                return INPUT_QUIT;
                            case GIIUC_Space:
                                return INPUT_CONTINUE;
                            case GIIUC_Delete:
                                return INPUT_BACK;
                    }
                    break;
        }
    }
    
    return INPUT_NOKEY;
}
