//---GEM-------------------------------------------------------------------------
//	convert.cpp - color converting function
//
//	desc: 
//		this function are used during txture creations
//-------------------------------------------------------------------------------
#include "convert.h"

//------------------------------------------------------------------------------
//	color convert function
//------------------------------------------------------------------------------

WORD C24Convert16(DWORD color)
{
	WORD	newr, newb, newg;
	WORD	r, g, b;

	r = (WORD)(color&0x00FF0000)>>16;
	g = (WORD)(color&0x0000FF00)>>8;
	b = (WORD)(color&0x000000FF);

	newr = (WORD)(31.0f*(FLOAT)r/255.0f);
	newg = (WORD)(63.0f*(FLOAT)g/255.0f);
	newb = (WORD)(31.0f*(FLOAT)b/255.0f);

	return (WORD)(newr<<11) + (WORD)(newg<<5) + (WORD)newb;
}


WORD C24Convert16(BYTE r, BYTE g, BYTE b)
{
	WORD	newr, newb, newg;

	newr = (WORD)(31.0f*(FLOAT)r/255.0f);
	newg = (WORD)(63.0f*(FLOAT)g/255.0f);
	newb = (WORD)(31.0f*(FLOAT)b/255.0f);

	return (WORD)(newr<<11) + (WORD)(newg<<5) + (WORD)newb;
}

WORD C24Convert15(DWORD color)
{
	WORD	newr, newb, newg;
	WORD	r, g, b;

	r = (WORD)(color&0x00FF0000)>>16;
	g = (WORD)(color&0x0000FF00)>>8;
	b = (WORD)(color&0x000000FF);

	newr = (WORD)(31.0f*(FLOAT)r/255.0f);
	newg = (WORD)(31.0f*(FLOAT)g/255.0f);
	newb = (WORD)(31.0f*(FLOAT)b/255.0f);

	return (WORD)(newr<<10) + (WORD)(newg<<5) + (WORD)newb;
}

WORD C24Convert15(BYTE r, BYTE g, BYTE b)
{
	WORD	newr, newb, newg;
	
	newr = (WORD)(31.0f*(FLOAT)r/255.0f);
	newg = (WORD)(31.0f*(FLOAT)g/255.0f);
	newb = (WORD)(31.0f*(FLOAT)b/255.0f);

	return (WORD)(newr<<10) + (WORD)(newg<<5) + (WORD)newb;
}

WORD C16Convert15(WORD color)
{
	
	return  ((color&0xF800)>>1) + (((color&0x07E0)>>1)&0x03E0) + (color&0x001F);
}

WORD C16Convert15(BYTE r, BYTE g, BYTE b)
{
	return (WORD)(r<<10) + (WORD)((g>>1)<<5) + (WORD)b;
}

WORD C15Convert16(WORD color)
{
	
	return  ((color&0x7C00)<<1) + ((color&0x03E0)<<1) + (color&0x001F);
}

DWORD C15Convert24(WORD color)
{
	DWORD		r = (color&0x7C00)>>7;
	DWORD		g = (color&0x03E0)>>2;
	DWORD		b = (color&0x001F)<<3;
	
	return (r<<16) + (g<<8) + b;
}

WORD C15Convert16(BYTE r, BYTE g, BYTE b)
{	

	return (WORD)(r<<11) + (WORD)(g<<6) + (WORD)b;
}



//--------------------------------------------------------------------------
//	block convert function
//--------------------------------------------------------------------------

VOID B24Convert16(LPVOID& block, DWORD width, DWORD height)
{
	BYTE*			buff = (BYTE*)block;
	WORD*			target = new WORD[width*height];

	for( DWORD i = 0 ; i<height ; i++ )
		for( DWORD j = 0 ; j<width ; j+=3 )
		{
			target[i*width+j] = C24Convert16( buff[i*height*3 + j*3 + 0], 
											  buff[i*height*3 + j*3 + 1],
											  buff[i*height*3 + j*3 + 2] );
		}

	delete block;
	block = target;
}


VOID B32Convert16(LPVOID& block, DWORD width, DWORD height)
{
	DWORD*			buff = (DWORD*)block;
	WORD*			target = new WORD[width*height];
	
	for( DWORD i = 0 ; i<height ; i++ )
		for( DWORD j = 0 ; j<width ; j++ )
			target[i*width + j] = C24Convert16( buff[i*width + j] );

	delete block;
	block = target;
}	

VOID B24Convert15(LPVOID& block, DWORD width, DWORD height)
{
	BYTE*			buff = (BYTE*)block;
	WORD*			target = new WORD[width*height];

	for( DWORD i = 0 ; i<height ; i++ )
		for( DWORD j = 0 ; j<width ; j+=3 )
		{
			target[i*width+j] = C24Convert15( buff[i*height*3 + j*3 + 0], 
											  buff[i*height*3 + j*3 + 1],
											  buff[i*height*3 + j*3 + 2] );
		}

	delete block;
	block = target;
}			


VOID B32Convert15(LPVOID& block, DWORD width, DWORD height)
{
	DWORD*			buff = (DWORD*)block;
	WORD*			target = new WORD[width*height];
	
	for( DWORD i = 0 ; i<height ; i++ )
		for( DWORD j = 0 ; j<width ; j++ )
			target[i*width + j] = C24Convert15( buff[i*width + j] );

	delete block;
	block = target;
}

VOID B16Convert15(LPVOID& block, DWORD width, DWORD height)
{
	WORD*			buff = (WORD*)block;

	for( DWORD i = 0 ; i<height ; i++ )
		for( DWORD j = 0 ; j<width ; j++ )
			buff[i*width + j] = C16Convert15( buff[i*width + j] );
}

//--------------------------------------------------------------------------
//	surface convert function
//--------------------------------------------------------------------------
//LPDIRECTDRAWSURFACE4 SufraceConvert(LPDIRECTDRAWSURFACE4 pdds, BYTE desireBPP)

