#ifndef	__GEMMATH_H_
#define __GEMMATH_H_

#include "gem.h"
#include <d3d.h>

D3DVALUE   Length(GEM_VECTOR& v);
GEM_VECTOR Normalize(GEM_VECTOR& v);
D3DVALUE   Dot(GEM_VECTOR& v, GEM_VECTOR& u);
GEM_VECTOR Cross(GEM_VECTOR& v, GEM_VECTOR& u);
GEM_VECTOR Lerp(GEM_VECTOR& v, GEM_VECTOR& u, D3DVALUE a);
GEM_VECTOR operator+ (GEM_VECTOR& v, GEM_VECTOR& u);
GEM_VECTOR operator- (GEM_VECTOR& v, GEM_VECTOR& u);
GEM_VECTOR operator- (GEM_VECTOR& v);
GEM_VECTOR operator* (GEM_VECTOR& v, D3DVALUE a);
GEM_VECTOR operator* (D3DVALUE a, GEM_VECTOR& v);
D3DVECTOR  GetD3DVECTOR(GEM_VECTOR& v);


GEM_MATRIX ZeroMatrix();
GEM_MATRIX IdentMatrix();
GEM_MATRIX operator* (GEM_MATRIX& A, GEM_MATRIX& B);
GEM_VECTOR operator* (GEM_VECTOR& a, GEM_MATRIX& A);
GEM_MATRIX operator* (D3DVALUE a, GEM_MATRIX& A);
GEM_MATRIX operator* (GEM_MATRIX& A, D3DVALUE a);
GEM_MATRIX operator- (GEM_MATRIX& A);
GEM_MATRIX operator+ (GEM_MATRIX& A, GEM_MATRIX& B);
GEM_MATRIX operator- (GEM_MATRIX& A, GEM_MATRIX& B);
GEM_MATRIX Transpose(GEM_MATRIX& A);
GEM_MATRIX Invert(GEM_MATRIX& a);
GEM_MATRIX Inverse(GEM_MATRIX& A);
D3DMATRIX  GetD3DMATRIX(GEM_MATRIX& mat);
GEM_MATRIX SetTranslationMatrix(GEM_VECTOR& vTrans);
GEM_MATRIX SetScaleMatrix(GEM_VECTOR& vScale);
GEM_MATRIX SetRotationMatrix(GEM_VECTOR& vAxis, D3DVALUE theta);
GEM_MATRIX SetViewMatrix(GEM_VECTOR& CamPos, GEM_VECTOR& CamTrg);
GEM_MATRIX SetCameraMatrix(GEM_VECTOR& CamPos, GEM_VECTOR& CamTrg, D3DVALUE roll);
GEM_MATRIX SetProjectionMatrix(D3DVALUE fov, D3DVALUE nearZ, D3DVALUE farZ, D3DVALUE aspect);
void	   SwapMatrix(GEM_MATRIX& A);


GEM_QUATERNION Normalize(GEM_QUATERNION& q);
D3DVALUE	   Norm(GEM_QUATERNION& q);
GEM_QUATERNION Inverse(GEM_QUATERNION& q);
GEM_QUATERNION UnityInverse(GEM_QUATERNION& q);	
GEM_QUATERNION exp(GEM_QUATERNION& q);
GEM_QUATERNION ln(GEM_QUATERNION& q);
GEM_QUATERNION operator^(GEM_QUATERNION& q, D3DVALUE t);
D3DVALUE	   Dot(GEM_QUATERNION& p, GEM_QUATERNION& q);
GEM_QUATERNION Cross(GEM_QUATERNION& p, GEM_QUATERNION& q);
GEM_QUATERNION Slerp(GEM_QUATERNION& p, GEM_QUATERNION& q, D3DVALUE t); 
GEM_QUATERNION ExtraSpinSlerp(GEM_QUATERNION& p, GEM_QUATERNION& q, D3DVALUE t, D3DVALUE spin);
GEM_QUATERNION Squad(GEM_QUATERNION& p, GEM_QUATERNION& a, GEM_QUATERNION& b, GEM_QUATERNION& q, D3DVALUE t);
GEM_QUATERNION operator*(GEM_QUATERNION& p, GEM_QUATERNION& q);
GEM_QUATERNION operator*(GEM_QUATERNION& p, D3DVALUE a);
GEM_QUATERNION operator*(D3DVALUE a, GEM_QUATERNION& p);
GEM_QUATERNION operator+(GEM_QUATERNION& p, GEM_QUATERNION& q);
GEM_QUATERNION operator-(GEM_QUATERNION& p, GEM_QUATERNION& q);
GEM_QUATERNION operator-(GEM_QUATERNION& q);
GEM_QUATERNION FromAxisAngle(GEM_VECTOR& vAxis, D3DVALUE angle);
GEM_QUATERNION FromAxisAngle(D3DVALUE x, D3DVALUE y, D3DVALUE z, D3DVALUE angle);
GEM_MATRIX	   FromQuat(GEM_QUATERNION& q);	

#endif /*__GEMMATH_H_*/
