//-----------------------------------------------------------------------------
//	textures.h header file for texture engine
//-----------------------------------------------------------------------------



//-----------------------------------------------------------------------------
//	structur definitions
//-----------------------------------------------------------------------------

#ifndef		__TEXTURES_H_
#define		__TEXTURES_H_

#include	<d3d.h>
#include	<ddraw.h>
#include	<tchar.h>
#include	<stdio.h>	

struct	GEM_TEXTURE
{

	LPDIRECTDRAWSURFACE4	pddsSurface;
	LPDIRECT3DTEXTURE2		pd3dTexture;

	HBITMAP					hbBitmap;
	LPVOID					pBuffer;
	TCHAR					name[80];

	DWORD					dwStage;
	BOOL					bPalettized;

	DDSURFACEDESC			ddsd;

	GEM_TEXTURE				*next, *prev;


	~GEM_TEXTURE();

};


struct	TEXTUREFORMATSEARCH
{
	LPDDPIXELFORMAT			pddpf;

	WORD					dwBPP;
	BOOL					bUsePalette;
	BOOL					bFound;
};


//--------------------------------------------------------------------------------
//	function prototypes
//--------------------------------------------------------------------------------
HRESULT AddTexture(TCHAR* name, DWORD stage = 0);
HRESULT UpdateTexture(TCHAR* name, LPDIRECT3DDEVICE3 pd3dDevice);
HRESULT UpdateAllTextures(LPDIRECT3DDEVICE3 pd3dDevice);
LPDIRECT3DTEXTURE2 GetTexture(TCHAR* name);
LPDIRECTDRAWSURFACE4 GetSurface(TCHAR* name);
HRESULT RemoveTexture(TCHAR* name);

#endif
