//-DIRECTGEM---------------------------------------------------------------------
//	matrix functions & opeartors
//
//	update:
//
//	desc:
//
//	(c) ZONE51 1999
//-------------------------------------------------------------------------------

#include "gemmath.h"
#include <math.h>

GEM_MATRIX ZeroMatrix()
{
	GEM_MATRIX		mat;

	ZeroMemory( &mat, sizeof(mat) );

	return			mat;
}


GEM_MATRIX IdentMatrix()
{
	GEM_MATRIX		mat;

	ZeroMemory( &mat, sizeof(mat) );
	mat( 1, 1 ) = 1.0f;
	mat( 2, 2 ) = 1.0f;
	mat( 3, 3 ) = 1.0f;
	mat( 4, 4 ) = 1.0f;

	return mat;
}


GEM_MATRIX operator* (GEM_MATRIX& A, GEM_MATRIX& B)
{
	GEM_MATRIX		tmp;

	tmp(1,1)=A(1,1)*B(1,1) + A(1,2)*B(2,1) + A(1,3)*B(3,1) + A(1,4)*B(4,1);
	tmp(1,2)=A(1,1)*B(1,2) + A(1,2)*B(2,2) + A(1,3)*B(3,2) + A(1,4)*B(4,2);
	tmp(1,3)=A(1,1)*B(1,3) + A(1,2)*B(2,3) + A(1,3)*B(3,3) + A(1,4)*B(4,3);
	tmp(1,4)=A(1,1)*B(1,4) + A(1,2)*B(2,4) + A(1,3)*B(3,4) + A(1,4)*B(4,4);

	tmp(2,1)=A(2,1)*B(1,1) + A(2,2)*B(2,1) + A(2,3)*B(3,1) + A(2,4)*B(4,1);
	tmp(2,2)=A(2,1)*B(1,2) + A(2,2)*B(2,2) + A(2,3)*B(3,2) + A(2,4)*B(4,2);
	tmp(2,3)=A(2,1)*B(1,3) + A(2,2)*B(2,3) + A(2,3)*B(3,3) + A(2,4)*B(4,3);
	tmp(2,4)=A(2,1)*B(1,4) + A(2,2)*B(2,4) + A(2,3)*B(3,4) + A(2,4)*B(4,4);

	tmp(3,1)=A(3,1)*B(1,1) + A(3,2)*B(2,1) + A(3,3)*B(3,1) + A(3,4)*B(4,1);
	tmp(3,2)=A(3,1)*B(1,2) + A(3,2)*B(2,2) + A(3,3)*B(3,2) + A(3,4)*B(4,2);
	tmp(3,3)=A(3,1)*B(1,3) + A(3,2)*B(2,3) + A(3,3)*B(3,3) + A(3,4)*B(4,3);
	tmp(3,4)=A(3,1)*B(1,4) + A(3,2)*B(2,4) + A(3,3)*B(3,4) + A(3,4)*B(4,4);

	tmp(4,1)=A(4,1)*B(1,1) + A(4,2)*B(2,1) + A(4,3)*B(3,1) + A(4,4)*B(4,1);
	tmp(4,2)=A(4,1)*B(1,2) + A(4,2)*B(2,2) + A(4,3)*B(3,2) + A(4,4)*B(4,2);
	tmp(4,3)=A(4,1)*B(1,3) + A(4,2)*B(2,3) + A(4,3)*B(3,3) + A(4,4)*B(4,3);
	tmp(4,4)=A(4,1)*B(1,4) + A(4,2)*B(2,4) + A(4,3)*B(3,4) + A(4,4)*B(4,4);

	return tmp;
}


GEM_VECTOR operator* (GEM_VECTOR& a, GEM_MATRIX& A)
{
	GEM_VECTOR		tmp;
	
	D3DVALUE		x = a.x*A(1,1) + a.y*A(2,1) + a.z*A(3,1) + A(4,1);
	D3DVALUE		y = a.x*A(1,2) + a.y*A(2,2) + a.z*A(3,2) + A(4,2);
	D3DVALUE		z = a.x*A(1,3) + a.y*A(2,3) + a.z*A(3,3) + A(4,3);
	D3DVALUE		w = a.x*A(1,4) + a.y*A(2,4) + a.z*A(3,4) + A(4,4);

	if ( !w )
		return GEM_VECTOR( 0, 0, 0 );

	D3DVALUE		_1w = 1/w;

	tmp.x = x * _1w;
	tmp.y = y * _1w;
	tmp.z = z * _1w;

	return tmp;
}


GEM_MATRIX operator* (D3DVALUE a, GEM_MATRIX& A)
{
	GEM_MATRIX		tmp;

	for( int i = 1 ; i<=4 ; i++ )
		for (int j = 1 ; j<=4 ; j++ )
			tmp( i, j )= a*A( i, j );

	return tmp;
}

GEM_MATRIX operator* (GEM_MATRIX& A, D3DVALUE a)
{
	GEM_MATRIX		tmp;

	for( int i = 1 ; i<=4 ; i++ )
		for (int j = 1 ; j<=4 ; j++ )
			tmp( i, j )= a*A( i, j );

	return tmp;
}


GEM_MATRIX operator+ (GEM_MATRIX& A, GEM_MATRIX& B)
{
	GEM_MATRIX		tmp;

	for( int i = 1 ; i<=4 ; i++ )
		for( int j = 1 ; j<=4; j++ )
			tmp( i, j ) = A( i, j ) + B( i, j );

	return tmp;
}

GEM_MATRIX operator- (GEM_MATRIX& A)
{
	GEM_MATRIX		tmp;

	for( int i = 1 ; i<=4 ; i++ )
		for( int j = 1 ; j<=4; j++ )
			tmp( i, j ) = -A( i, j );

	return tmp;
}

GEM_MATRIX operator- (GEM_MATRIX& A, GEM_MATRIX& B)
{
	GEM_MATRIX		tmp;

	for( int i = 1 ; i<=4 ; i++ )
		for( int j = 1 ; j<=4; j++ )
			tmp( i, j ) = A( i, j ) - B( i, j );

	return tmp;
}


GEM_MATRIX Transpose(GEM_MATRIX& A)
{
	GEM_MATRIX		tmp;

	for( int i=1 ; i<=4; i++ )
		for( int j=0 ; j<=4 ; j++ )
			tmp( j, i ) = A( i, j );

	return tmp;
}


D3DMATRIX GetD3DMATRIX(GEM_MATRIX& mat)
{
	D3DMATRIX		d3dmat;
	
	d3dmat._11 = mat(1,1); d3dmat._12 = mat(1,2); d3dmat._13 = mat(1,3); d3dmat._14 = mat(1,4);
	d3dmat._21 = mat(2,1); d3dmat._22 = mat(2,2); d3dmat._23 = mat(2,3); d3dmat._24 = mat(2,4);
	d3dmat._31 = mat(3,1); d3dmat._32 = mat(3,2); d3dmat._33 = mat(3,3); d3dmat._34 = mat(3,4);
	d3dmat._41 = mat(4,1); d3dmat._42 = mat(4,2); d3dmat._43 = mat(4,3); d3dmat._44 = mat(4,4);

	return d3dmat;
}


GEM_MATRIX SetTranslationMatrix(GEM_VECTOR& vTrans)
{
	GEM_MATRIX		mat = IdentMatrix();

	mat( 4, 1 ) = vTrans.x;
	mat( 4, 2 ) = vTrans.y;
	mat( 4, 3 ) = vTrans.z;

	return mat;
}

GEM_MATRIX SetScaleMatrix(GEM_VECTOR& vScale)
{
	GEM_MATRIX		mat = IdentMatrix();

	mat( 1, 1 ) = vScale.x;
	mat( 2, 2 ) = vScale.y;
	mat( 3, 3 ) = vScale.z;

	return mat;
}

GEM_MATRIX SetRotationMatrix(GEM_VECTOR& vAxis, D3DVALUE theta)
{
	GEM_MATRIX		tmp		= IdentMatrix();

	D3DVALUE		cost	= cos(theta);
	D3DVALUE		_1cost	= 1-cost;
	D3DVALUE		sint	= sin(theta);
	D3DVALUE		x		= vAxis.x;
	D3DVALUE		y		= vAxis.y;
	D3DVALUE		z		= vAxis.z;
	D3DVALUE		x2		= x*x;
	D3DVALUE		y2		= y*y;
	D3DVALUE		z2		= z*z;
	D3DVALUE		xy		= x*y;
	D3DVALUE		xz		= x*z;
	D3DVALUE		yz		= y*z;

	tmp( 1, 1 ) = x2 + cost*(1 - x2);
	tmp( 1, 2 ) = xy*_1cost + z*sint;
	tmp( 1, 3 ) = xz*_1cost - y*sint;

	tmp( 2, 1 ) = xy*_1cost - z*sint;
	tmp( 2, 2 ) = y2 + cost*(1 - y2);
	tmp( 2, 3 ) = yz*_1cost + x*sint;

	tmp( 3, 1 ) = xz*_1cost - y*sint;
	tmp( 3, 2 ) = yz*_1cost - x*sint;	
	tmp( 3, 3 ) = z2 + cost*(1 - z2);
    
	return tmp;
}

GEM_MATRIX SetViewMatrix(GEM_VECTOR& CamPos, GEM_VECTOR& CamTrg)
{
    
    GEM_VECTOR		vView = CamTrg - CamPos;
	GEM_VECTOR		vWorldUp( 0.0f, 1.0f, 0.0f );

    vView = Normalize( vView );

    D3DVALUE		DotProd = Dot( vWorldUp, vView );
    GEM_VECTOR		vUp = vWorldUp - DotProd * vView;

    vUp = Normalize( vUp );

    GEM_VECTOR		vRight = Cross( vUp, vView );
    
	GEM_MATRIX		mat = IdentMatrix();
    mat(1,1) = vRight.x;    mat(1,2) = vUp.x;    mat(1,3) = vView.x;
    mat(2,1) = vRight.y;    mat(2,2) = vUp.y;    mat(2,3) = vView.y;
    mat(3,1) = vRight.z;    mat(3,2) = vUp.z;    mat(3,3) = vView.z;

    
    mat(4,1) = - Dot( CamPos, vRight );
    mat(4,2) = - Dot( CamPos, vUp );
    mat(4,3) = - Dot( CamPos, vView );

    return mat;
}

GEM_MATRIX SetProjectionMatrix(D3DVALUE fov, D3DVALUE nearZ, D3DVALUE farZ, D3DVALUE aspect)
{
	D3DVALUE		ang = 0.5*fov*3.14159/180;
	D3DVALUE		_cos = cos( ang );
	D3DVALUE		_sin = sin( ang );
	D3DVALUE		_ctg = _cos/_sin;

	D3DVALUE		w = aspect * _ctg;
	D3DVALUE		h = _ctg;  
    D3DVALUE		Q = farZ / ( farZ - nearZ );

    GEM_MATRIX		mat = ZeroMatrix();
    mat(1,1) = w;
    mat(2,2) = h;
    mat(3,3) = Q;
    mat(3,4) = 1.0f;
    mat(4,3) = -Q*nearZ;

	return mat;
}


GEM_MATRIX SetCameraMatrix(GEM_VECTOR& CamPos, GEM_VECTOR& CamTrg, D3DVALUE roll)
{
	GEM_VECTOR		dir = CamTrg-CamPos;
	D3DVALUE		focus = Length( dir );

	D3DVALUE		alpha = -atan2(dir.x,dir.z);
	D3DVALUE		beta = asin(dir.y/focus);
	D3DVALUE		gamma = roll*3.14159f/180.0f;

	D3DVALUE		sina = sin(alpha); 
	D3DVALUE		cosa = cos(alpha);
	D3DVALUE		sinb = sin(beta);  
	D3DVALUE		cosb = cos(beta);
	D3DVALUE		sing = sin(gamma); 
	D3DVALUE		cosg = cos(gamma);

	GEM_MATRIX		mtx = IdentMatrix();

	mtx(1,1) = sina*sinb*sing + cosa*cosg;
	mtx(2,1) = cosb*sing;
	mtx(3,1) = sina*cosg - cosa*sinb*sing;

	mtx(1,2) = sina*sinb*cosg - cosa*sing;
	mtx(2,2) = cosb*cosg;
    mtx(3,2) = -cosa*sinb*cosg - sina*sing;

	mtx(1,3) = -sina*cosb;
    mtx(2,3) = sinb;
    mtx(3,3) = cosa*cosb;

	mtx = SetTranslationMatrix(-CamPos)*mtx;

    return mtx;
}


void SwapMatrix( GEM_MATRIX& A )
{
	D3DVALUE		tmp;
	WORD			i;

	for( i = 1 ; i<=4 ; i++ )
	{
		tmp		= A(i,2);
		A(i,2)	= A(i,3);
		A(i,3)	= tmp;
	}

	for( i = 1 ; i<=4 ; i++)
	{
		tmp		= A(2,i);
		A(2,i)	= A(3,i);
		A(3,i)	= tmp;
	}
}



