//-DIRECTGEM-------------------------------------------------------------------
//
//
//-----------------------------------------------------------------------------

#ifndef __MATRIX_H_
#define __MATRIX_H_

#include <d3d.h>
#include "vector.h"

class GEM_MATRIX
{
public:

	D3DVALUE	MATRIX[4][4];

	GEM_MATRIX()
	{
	}

	GEM_MATRIX(GEM_MATRIX& mat)
	{
		for( int i = 0 ; i<4 ; i++ )
			for( int j=0 ; j<4; j++ )
				MATRIX[i][j] = mat.MATRIX[i][j];
	}

	GEM_MATRIX(D3DMATRIX& mat)
	{
		MATRIX[0][0]=mat._11; MATRIX[0][1]=mat._12; MATRIX[0][2]=mat._13; MATRIX[0][3]=mat._14;
		MATRIX[1][0]=mat._12; MATRIX[1][1]=mat._22; MATRIX[1][2]=mat._23; MATRIX[1][3]=mat._24;
		MATRIX[2][0]=mat._13; MATRIX[2][1]=mat._32; MATRIX[2][2]=mat._33; MATRIX[2][3]=mat._34;
		MATRIX[3][0]=mat._14; MATRIX[3][1]=mat._42; MATRIX[3][2]=mat._43; MATRIX[3][3]=mat._44;
	}

	D3DVALUE& operator() (int row, int col)
	{
		return MATRIX[row-1][col-1];
	}

	GEM_MATRIX& operator= (GEM_MATRIX& mat)
	{
		if( this==&mat )
			return *this;

		for( int i=0 ; i<4 ; i++ )
			for( int j=0 ; j<4 ;  j++)
				MATRIX[i][j]=mat( i+1, j+1 );

		return *this;
	}

};

GEM_MATRIX ZeroMatrix();
GEM_MATRIX IdentMatrix();
GEM_MATRIX operator* (GEM_MATRIX& A, GEM_MATRIX& B);
GEM_VECTOR operator* (GEM_VECTOR& a, GEM_MATRIX& A);
GEM_MATRIX operator* (D3DVALUE a, GEM_MATRIX& A);
GEM_MATRIX operator* (GEM_MATRIX& A, D3DVALUE a);
GEM_MATRIX operator- (GEM_MATRIX& A);
GEM_MATRIX operator+ (GEM_MATRIX& A, GEM_MATRIX& B);
GEM_MATRIX operator- (GEM_MATRIX& A, GEM_MATRIX& B);
GEM_MATRIX Transpose(GEM_MATRIX& A);
GEM_MATRIX Inverse(GEM_MATRIX& A);
D3DMATRIX  GetD3DMATRIX(GEM_MATRIX& mat);
GEM_MATRIX SetTranslationMatrix(GEM_VECTOR& vTrans);
GEM_MATRIX SetScaleMatrix(GEM_VECTOR& vScale);
GEM_MATRIX SetRotationMatrix(GEM_VECTOR& vAxis, D3DVALUE theta);
GEM_MATRIX SetCameraMatrix(GEM_VECTOR& CamPos, GEM_VECTOR& CamTrg);
GEM_MATRIX SetProjectionMatrix(D3DVALUE fov, D3DVALUE nearZ, D3DVALUE farZ, D3DVALUE aspect);
void	   SwapMatrix(GEM_MATRIX& A);

#endif	/* __MATRIX_H_ */



