//---DIRECTGEM----------------------------------------------------------------
//
//----------------------------------------------------------------------------

#ifndef __QUAT_H_
#define __QUAT_H_

#include <d3d.h>
#include "matrix.h"

class GEM_QUATERNION
{
public:

	D3DVALUE	w, x, y, z;	

	GEM_QUATERNION(D3DVALUE a = 0) : w(a), x(a), y(a), z(a)
	{
	}

	GEM_QUATERNION(D3DVALUE _w, D3DVALUE _x, D3DVALUE _y, D3DVALUE _z) : w(_w), x(_x), y(_y), z(_z)
	{
	}

	GEM_QUATERNION(GEM_QUATERNION& q) : w(q.w), x(q.x), y(q.y), z(q.z)
	{
	}
};


GEM_QUATERNION Normalize(GEM_QUATERNION& q);
D3DVALUE	   Norm(GEM_QUATERNION& q);
GEM_QUATERNION Inverse(GEM_QUATERNION& q);
GEM_QUATERNION UnityInverse(GEM_QUATERNION& q);	
GEM_QUATERNION exp(GEM_QUATERNION& q);
GEM_QUATERNION ln(GEM_QUATERNION& q);
GEM_QUATERNION operator^(GEM_QUATERNION& q, D3DVALUE t);
D3DVALUE	   Dot(GEM_QUATERNION& p, GEM_QUATERNION& q);
GEM_QUATERNION Cross(GEM_QUATERNION& p, GEM_QUATERNION& q);
GEM_QUATERNION Slerp(GEM_QUATERNION& p, GEM_QUATERNION& q, D3DVALUE t); 
GEM_QUATERNION ExtraSpinSlerp(GEM_QUATERNION& p, GEM_QUATERNION& q, D3DVALUE t, D3DVALUE spin);
GEM_QUATERNION Squad(GEM_QUATERNION& p, GEM_QUATERNION& a, GEM_QUATERNION& b, GEM_QUATERNION& q, D3DVALUE t);
GEM_QUATERNION operator*(GEM_QUATERNION& p, GEM_QUATERNION& q);
GEM_QUATERNION operator*(GEM_QUATERNION& p, D3DVALUE a);
GEM_QUATERNION operator*(D3DVALUE a, GEM_QUATERNION& p);
GEM_QUATERNION operator+(GEM_QUATERNION& p, GEM_QUATERNION& q);
GEM_QUATERNION operator-(GEM_QUATERNION& p, GEM_QUATERNION& q);
GEM_QUATERNION operator-(GEM_QUATERNION& q);
GEM_QUATERNION FromAxisAngle(GEM_VECTOR& vAxis, D3DVALUE angle);
GEM_QUATERNION FromAxisAngle(D3DVALUE x, D3DVALUE y, D3DVALUE z, D3DVALUE angle);
GEM_MATRIX	   FromQuat(GEM_QUATERNION& q);	

#endif /* __QUAT_H_ */







	
