//---DIRECTGEM-------------------------------------------------------------------
//
//-------------------------------------------------------------------------------

#ifndef __VECTOR_H_
#define __VECTOR_H_

#include <d3d.h>

//-------------------------------------------------------------------------------
//	vector class definition
//-------------------------------------------------------------------------------

class GEM_VECTOR
{
public:
	D3DVALUE	x, y, z;

	GEM_VECTOR(D3DVALUE a = 0) : x(a), y(a), z(a)
	{
	}

	GEM_VECTOR(D3DVALUE a, D3DVALUE b, D3DVALUE c) : x(a), y(b), z(c)
	{
	}

	GEM_VECTOR(GEM_VECTOR& v) : x(v.x), y(v.y), z(v.z)
	{
	}

	GEM_VECTOR(D3DVECTOR& v) : x(v.dvX), y(v.dvY), z(v.dvZ)
	{
	}

};

//-------------------------------------------------------------------------------
//	prototypes
//-------------------------------------------------------------------------------

D3DVALUE   Length(GEM_VECTOR& v);
GEM_VECTOR Normalize(GEM_VECTOR& v);
D3DVALUE   Dot(GEM_VECTOR& v, GEM_VECTOR& u);
GEM_VECTOR Cross(GEM_VECTOR& v, GEM_VECTOR& u);
GEM_VECTOR Lerp(GEM_VECTOR& v, GEM_VECTOR& u, D3DVALUE a);
GEM_VECTOR operator+ (GEM_VECTOR& v, GEM_VECTOR& u);
GEM_VECTOR operator- (GEM_VECTOR& v, GEM_VECTOR& u);
GEM_VECTOR operator- (GEM_VECTOR& v);
GEM_VECTOR operator* (GEM_VECTOR& v, D3DVALUE a);
GEM_VECTOR operator* (D3DVALUE a, GEM_VECTOR& v);
D3DVECTOR  GetD3DVECTOR(GEM_VECTOR& v);

#endif /* __VECTOR_H_ */
