
// cubes for everyone!
// 	-- brioche/aspirine <xdefrang@csi.com>

#ifndef _CUBE_H_INCLUDED
#define _CUBE_H_INCLUDED

#include <cmath>
#include <ptc.h>
#include "Vector.h"
#include "Matrix.h"
#include "Poly.h"


class Cube_Base {
protected:
	Matrix rot;
	float cx ,cy, cz;
	float fx, fy;
	int32 col;
	int nvert;
	Vector *vert;
	Poly_Point *pts;

	void transform();

public:	
	Cube_Base( int n, int32 color = 0xffffff, float centx = 160.0f, float centy = 100.0f, float centz = 512.0f );
	~Cube_Base();
	void rotate( float x, float y, float z ) { rot.rotate_xyz( x, y, z ); }	
	void set_center( float x, float y, float z = 512.0f ) { cx = x; cy = y; cz = z; }
	void set_perspective( float x, float y ) { fx = x; fy = y; }
};

class Cube : public Cube_Base {
public: 
	Cube( float size, int32 color = 0xffffff, float centx = 160.0f, float centy = 100.0f, float centz = 512.0f );
	void draw( int32 *surface );
};

class Cube2 : public Cube_Base {
public: 
	Cube2( float size, int32 color = 0xffffff, float centx = 160.0f, float centy = 100.0f, float centz = 512.0f );
	void draw( int32 *surface );
};

#endif // _CUBE_H_INCLUDED

