
#include "DynSys.h"


Dynamic_System::Dynamic_System( int num, float ampl, float centx = 160, float centy = 100 )
{
	n = num;
	amp = ampl;
	cx = centx;
	cy = centy;
	pts = new Poly_Point [n];
}

Dynamic_System::Dynamic_System( const Dynamic_System &s )
{
	*this = s;
}

Dynamic_System::~Dynamic_System()
{
	delete [] pts;
}

const Dynamic_System &Dynamic_System::operator = ( const Dynamic_System &s )
{
	if ( this != &s ) {
		delete [] pts;
		n = s.n;
		amp = s.amp;
		cx = s.cx;
		cy = s.cy;
		pts = new Poly_Point [n];
	}
	return *this;
}

void Dynamic_System::update( float t )
{
	for ( int i = 0; i < n; i++ ) {
		float b = 1.5f+float(i)*(1.0f/33.33333f);
		float a = t*(1.0f/33.33333f);
		float cosa = cos(a*0.1);
		float cosab = cos(a*b);
		float cosapb = cos(a+b);	
		float sina = sin(a*0.1);
		float sinab = sin(a*b);
		float sinapb = sin(a+b);	
		float ampb = amp*b;
		float ampc = amp*cos(a*0.05);
		float ampcosab = amp*cosab;
		float cosapbampb = cosapb*ampb;
		float sinapbampb = sinapb*ampb;
		float cosapbampcosab = cosapb*ampcosab;
		float sinapbampcosab = sinapb*ampcosab;
		float cosapbsinapb = cosapb*sinapb;
		float cosapbcosapb = cosapb*cosapb;
		pts[i].x = int(cx+(sina*sinapbampcosab+cosa*(cosapbampb*cosab+ampc*cosapbsinapb)));
		pts[i].y = int(cy+(sina*cosapbampcosab+cosa*(cosapbampb*sinab+ampc*cosapbcosapb)));
	}
}

void Dynamic_System::draw( int32 *surface )
{
	sc_polyline( pts, n, surface );
}


