
// Dynamic system of moving particles joined with a polyline
// 	-- brioche/aspirine <xdefrang@csi.com>

#ifndef _DYNSYS_H_INCLUDED
#define _DYNSYS_H_INCLUDED

#include <cmath>
#include <ptc.h>
#include "Poly.h"


class Dynamic_System {
	int n;
	float cx, cy, amp, t;
	Poly_Point *pts;
public: 
	Dynamic_System( int num, float ampl, float centx = 160, float centy = 100 );
	Dynamic_System( const Dynamic_System &s );
	~Dynamic_System();

	const Dynamic_System &operator = ( const Dynamic_System &s );

	void set_center( float x, float y ) { cx = x; cy = y; }

	void update( float t );	
	void draw( int32 *surface );
};

#endif // _DYNSYS_H_INCLUDED

