
#include "GZ.h"

#define LOCAL_BUFF_SIZE		1024

static char local_buff[LOCAL_BUFF_SIZE];

//
//	B U F F E R
//

GZ_Buffer::GZ_Buffer( int granularity )
{
	buff = 0;
	alloc( granularity );
}

GZ_Buffer::~GZ_Buffer()
{
	free();
}

void GZ_Buffer::alloc( int granularity )
{
	if ( granularity < LOCAL_BUFF_SIZE )
		throw GZ_Error( "GZ_Buffer: granularity too tiny." );
	if ( buff )
		throw GZ_Error( "GZ_Buffer: buffer already allocated." );
	len = 0;
	sz = granul = granularity;

	// I'm using that goddamn malloc() cause i still don't know how the heck to
	// resize dynamically allocated memory using plain C++ instuctions
	// sorry, you'll have to cope with that...

	if ( (buff = (char *)malloc( sz )) == 0 )
		throw GZ_Error( "GZ_Buffer: malloc() failed." );
}

void GZ_Buffer::free()
{
	// make sure we call the globally defined free() function
	if ( buff )
		::free( buff );
}

void GZ_Buffer::put( char *data, int nbytes )
{
	if ( !buff )
		throw GZ_Error( "GZ_Buffer: null buffer exception." );
	if ( (len+nbytes) > sz ) {
		sz += granul;
		if ( (buff = (char *)realloc( buff, sz )) == 0 )	
			throw GZ_Error( "GZ_Buffer: realloc() failed." );
	}
	memcpy( buff+len, data, nbytes );	
	len += nbytes;
}

void GZ_Buffer::shrink()
{
	if ( len == sz ) 
		return;
	if ( (buff = (char *)realloc( buff, sz = len )) == 0 )	
		throw GZ_Error( "GZ_Buffer: realloc() failed." );
}

//
//	S T R E A M	
//

void GZ_Stream::defaults()
{
	file = buff = 0;
}

GZ_Stream::GZ_Stream()
{
	defaults();
}

GZ_Stream::GZ_Stream( GZ_Buffer &buffer )
{
	defaults();
	set_buffer( buffer );
}

GZ_Stream::GZ_Stream( const char filename[], GZ_Buffer &buffer )
{
	defaults();
	set_buffer( buffer );
	read( filename );
}

void GZ_Stream::set_buffer( GZ_Buffer &buffer )
{
	if ( buff )
		throw GZ_Error( "GZ_Stream: buffer already attached." );
	buff = &buffer;
}

void GZ_Stream::read( const char filename[] )
{
	if ( !buff )
		throw GZ_Error( "GZ_Stream: null buffer exception." );

	if ( (file = gzopen( filename, "rb" )) == 0 )
		throw GZ_Error( "GZ_Stream: gzopen() failed." );

	int bytes = -1;
	while ( bytes != 0 ) {
		if ( (bytes = gzread( file, local_buff, LOCAL_BUFF_SIZE )) < 0  )
			throw GZ_Error( "GZ_Stream: gzread() failed." );
		else if ( bytes > 0 )
			buff->put( local_buff, bytes );
	}
	
	if ( gzclose( file ) != Z_OK )
		throw GZ_Error( "GZ_Stream: gzclose() failed." );
}

