
/*
 *	GZ.h -- a set of upper level classes for zlib's gzip stream inflater
 *
 *		this library is Copyleft 1999 <xdefrang@csi.com> 	
 *		zlib is Copyright 1996, Jean-Loup Gailly & Mark Adler
 *
 *	oops! don't forget to link with `-lz'
 */


#ifndef _GZFILE_H_INCLUDED
#define _GZFILE_H_INCLUDED

#include <iostream>
#include <cstdlib>
#include <zlib.h>

// this exception may be raised by almost all methods
class GZ_Error {
	char *m;
public:
	GZ_Error( char msg[] ) { m = msg; };
	void report( ostream &os = std::cerr ) const { os << m << endl; };
};

// sort of handy `self-resizing' buffer class
// btw, it's a quite bad idea to share a buffer with several streams ;)
class GZ_Buffer {
	char *buff;
	int  len, sz, granul;
public:
	GZ_Buffer( int granularity );
	~GZ_Buffer();

	void alloc( int granularity = 4096 );
	void free();

	void put( char *data, int nbytes );
	int size() const { return len; };
	void *base() const { return (void *)buff; };

	void reset() { len = 0; };	// avoid truckloads of realloc's
	void shrink();			// useful for large granularity values
};

// core GZ stream reader/decoder
class GZ_Stream {
	gzFile file;		// see `zlib.h'
	GZ_Buffer *buff;
	void defaults();
public:
	GZ_Stream();
	GZ_Stream( GZ_Buffer &buff );
	GZ_Stream( const char filename[], GZ_Buffer &buff );
	void set_buffer( GZ_Buffer &buff );
	void read( const char filename[] );
};

#endif // _GZFILE_H_INCLUDED
