
#ifndef _LERP_H_INCLUDED
#define _LERP_H_INCLUDED

// linear interpolation template
template <class T> class Lerp {
	T x, y, i;
public:
	Lerp( T from, T to, T steps ) { set( from, to, steps ); }
	void set( T from, T to, T steps )  { x = from; y = to; i = (to-from)/steps; }

	bool done() const { return x == y; }
	T value() const { return x; }
	const Lerp &next() { x += i; return *this; };

	T operator () () const { value(); };
	const Lerp &operator ++ () { return next(); }
	const Lerp &operator ++ ( int dummy ) { return next(); }
};

// bilinear interpolation template
template <class T> class BLerp {
	T x, ix, y, iy;
	T s;
public:
	BLerp( T from1, T from2, T to1, T to2, T steps ) { set( from1, from2, to1, to2, steps ); }

	void set( T from1, T from2, T to1, T to2, T steps ) {
		s = steps;
		x = from1; ix = (to1-from1)/s;
		y = from2; iy = (to2-from2)/s;
	}

	bool done() const { return s == 0; }
	T value1() const { return x; }
	T value2() const { return y; }
	void value( T &a, T &b ) const { a = x; b = y; }
	const BLerp &next() { x += ix; y += iy; return *this; };

	const BLerp &operator ++ () { return next(); }
	const BLerp &operator ++ ( int dummy ) { return next(); }
};


#endif // _LERP_H_INCLUDED
