
#include "Loader.h"

Loader::Loader( bool verbose, int granularity )
{
	gzb = new GZ_Buffer( granularity );
	gzs = new GZ_Stream( *gzb );
	if ( verb = verbose )
		cerr << "Loader runs in verbose mode." << endl;
}

Loader::~Loader()
{
	delete gzb;
	delete gzs;
}

void Loader::load( const char *filename, int size, char8 *buffer )
{
	if ( verb )
		cerr << "Loading binary data \"" << filename << "\" (" << size << " bytes) - ";
	gzb->reset();
	gzs->read( filename );	
	char8 *ptr = (char8 *)gzb->base();
	memcpy( buffer, ptr, size );
	if ( verb )
		cerr << "ok" << endl;
}

void Loader::load( const char *filename, int w, int h, int32 *buffer )
{
	if ( verb )
		cerr << "Loading RGB pixelmap \"" << filename << "\" (" << w << "x" << h << "/24-bpp) - ";
	gzb->reset();
	gzs->read( filename );	
	char8 *ptr = (char8 *)gzb->base();
	for ( int i = 0; i < w*h; i++ )
		buffer[i] = rgb32( ptr[i*3], ptr[i*3+1], ptr[i*3+2] );
	if ( verb )
		cerr << "ok" << endl;
}


