
// small interface to midas sound system - brioche/aspirine
// warning : THIS IS C++ CODE !!!

#include "MIDAS.h"

volatile int sync_cnt = 0, sync_cnt2 = 0;
int prev_sync_cnt, prev_sync_cnt2;

static MIDASmodule *module = 0;
static MIDASmodulePlayHandle handle;
static MIDASplayStatus status;

MIDASechoSet *echoset = NULL;
MIDASechoSet *echoset2;

static void MIDAS_error()
{
	cerr << endl <<"MIDAS: " << MIDASgetErrorMessage(MIDASgetLastError()) << endl;
	exit(1);
}

static void MIDAS_sync_callback( unsigned sync, unsigned pos, unsigned row )
{
	//cerr << "sync " << hex << sync << " @ " << pos << "/" << dec << row << endl;
	if ( sync == 0x13 )
		sync_cnt++;
	else 
		sync_cnt2++;
}
	
void MIDAS_init( char *filename )
{
	unsigned           i, j, k;
	char               *name;
	int                key = 0, oldRow = 0;
	int                masterVolume = 64;
	char               *rcPath;

#ifdef __MIDAS_VERBOSE   
	cerr << "using MIDAS Digital Audio System version " << MIDASgetVersionString() << endl;
#endif
 
	if ( !MIDASstartup() )
		MIDAS_error();

#ifdef __MIDAS_VERBOSE
	cerr << "Initializing MIDAS..." << endl;
#endif

	if ( !MIDASinit() )
		MIDAS_error();

#ifdef __MIDAS_VERBOSE
	cerr << "Loading module..." << endl;
#endif
	if ( !(module = MIDASloadModule( filename )) )
		MIDAS_error();

	// play module, don't loop
	if ( (handle = MIDASplayModule( module, FALSE )) == 0 )
		MIDAS_error();

#ifdef __MIDAS_VERBOSE
	cerr << "playing at " << MIDASgetOption( MIDAS_OPTION_MIXRATE ) << "Hz, ";
	int mode = MIDASgetOption( MIDAS_OPTION_OUTPUTMODE );
	if ( mode & MIDAS_MODE_8BIT )
		cerr << '8';
	else
		cerr << "16";
	cerr << "-bit, ";
	if ( mode & MIDAS_MODE_MONO )
		cerr << "mono" << endl;
	else
		cerr << "stereo" << endl;
#endif

}

// starts midas playing thread
void MIDAS_play()
{
	MIDASsetMusicSyncCallback( handle, MIDAS_sync_callback );
	if( !MIDASstartBackgroundPlay(50))
		MIDAS_error();
}

void MIDAS_stop()
{
	MIDASstopBackgroundPlay();
	MIDASstopModule(handle);
}

void MIDAS_shutdown()
{
	MIDASfreeModule(module);
	MIDASclose();
}

int MIDAS_order()
{
        MIDASgetPlayStatus( handle, &status );
	return status.position;
}

int MIDAS_row()
{
        MIDASgetPlayStatus( handle, &status );
	return status.row;
}

void MIDAS_status( int &order, int &row )
{
        MIDASgetPlayStatus( handle, &status );
	order = status.position;
	row = status.row;
}

bool MIDAS_jump( int p )
{
	return MIDASsetPosition( handle, p );
}
