
//
//	Matrix.h - 4x4 transformation matrix class (unfinished!!!)
//	Written by Xavier Defrang <xdefrang@csi.com>
//

#ifndef _MATRIX_H_INCLUDED
#define _MATRIX_H_INCLUDED

#include <iostream>
#include <algorithm>
#include <cstring>
#include <cmath>

#include "Vector.h"

template <class coord> class Generic_Matrix {
        
	coord matrix[16];

	coord &operator () ( int row, int col )
	{
		return matrix[(row<<2)+col];
	}

	const coord &operator () ( int row, int col ) const 
	{
		return matrix[(row<<2)+col];
	}

public: 

	/*
	 *	I N I T I A L I Z A T I O N
	 */

	Generic_Matrix() 
	{
		idle();
	}

	Generic_Matrix( const Generic_Vector<coord> &o,
			const Generic_Vector<coord> &x = Generic_Vector<coord>(1,0,0),
			const Generic_Vector<coord> &y = Generic_Vector<coord>(0,1,0),
			const Generic_Vector<coord> &z = Generic_Vector<coord>(0,0,1) )
	{
		set_origin( o );
		set_local_x( x );
		set_local_y( y );
		set_local_z( z );
	}

	Generic_Matrix( const Generic_Matrix<coord> &m )
	{
		*this = m;
	}

	const Generic_Matrix &operator = ( const Generic_Matrix<coord> &m )
	{
		if ( this != &m )
			memcpy( this->matrix, m.matrix, 16*sizeof(coord) );
		return *this;
	}

	const Generic_Matrix<coord> &idle()
	{
		for ( int i = 0; i < 4; i++ )
			for ( int j = 0; j < 4; j++ )
				(*this)(i,j) = (i==j) ? 1 : 0;
		return *this;
	}

	/*
	 *	D A T A   A C C E S S
	 */

	Generic_Vector<coord> origin() const
	{
		return Generic_Vector<coord>( (*this)(3,0), (*this)(3,1), (*this)(3,2) );
	}

	Generic_Vector<coord> local_x() const
	{
		return Generic_Vector<coord>( (*this)(0,0), (*this)(1,0), (*this)(2,0) );
	}

	Generic_Vector<coord> local_y() const
	{
		return Generic_Vector<coord>( (*this)(0,1), (*this)(1,1), (*this)(2,1) );
	}

	Generic_Vector<coord> local_z() const
	{
		return Generic_Vector<coord>( (*this)(0,2), (*this)(1,2), (*this)(2,2) );
	}

	const Generic_Matrix<coord> &set_origin( coord x, coord y, coord z )
	{
		(*this)(3,0) = x;
		(*this)(3,1) = y;
		(*this)(3,2) = z;
		return *this;
	}

	const Generic_Matrix<coord> &set_local_x( coord x, coord y, coord z )
	{
		(*this)(0,0) = x;
		(*this)(1,0) = y;
		(*this)(2,0) = z;
		return *this;
	}

	const Generic_Matrix<coord> &set_local_y( coord x, coord y, coord z )
	{
		(*this)(0,1) = x;
		(*this)(1,1) = y;
		(*this)(2,1) = z;
		return *this;
	}

	const Generic_Matrix<coord> &set_local_z( coord x, coord y, coord z )
	{
		(*this)(0,2) = x;
		(*this)(1,3) = y;
		(*this)(2,4) = z;
		return *this;
	}

	const Generic_Matrix<coord> &set_origin( const Generic_Vector<coord> &v )
	{
		return set_origin( v.x, v.y, v.z );
	}

	const Generic_Matrix<coord> &set_local_x( const Generic_Vector<coord> &v )
	{
		return set_local_x( v.x, v.y, v.z );
	}

	const Generic_Matrix<coord> &set_local_y( const Generic_Vector<coord> &v )
	{
		return set_local_y( v.x, v.y, v.z );
	}

	const Generic_Matrix<coord> &set_local_z( const Generic_Vector<coord> &v )
	{
		return set_local_z( v.x, v.y, v.z );
	}

	/*
	 *	T R A N S L A T I O N
	 */

	const Generic_Matrix<coord> &translate( coord x, coord y, coord z )
	{
		return idle().set_origin( x, y, z );
	}

	const Generic_Matrix<coord> &translate( const Generic_Vector<coord> &v )
	{
		return translate( v.x, v.y, v.z );	
	}

	/*
	 *	R E S C A L I N G
	 */

	const Generic_Matrix<coord> &scale( coord x, coord y, coord z )
	{
		idle();
		(*this)(0,0) = x;	
		(*this)(1,1) = y;	
		(*this)(2,2) = z;	
		return *this;
	}

	const Generic_Matrix<coord> &scale( const Generic_Vector<coord> &v )
	{
		return scale( v.x, v.y, v.z );
	}

	/*
 	 *	R O T A T I O N
	 */

	const Generic_Matrix<coord> &rotate_x( coord a )
	{
		coord cosa = cos( a );
		coord sina = sin( a );

		idle();

		(*this)(1,1) = cosa;
		(*this)(1,2) = sina;
		(*this)(2,1) = -sina;
		(*this)(2,2) = cosa;

		return *this;
	}

	const Generic_Matrix<coord> &rotate_y( coord a )
	{
		coord cosa = cos( a );
		coord sina = sin( a );

		idle();

		(*this)(0,0) = cosa;
		(*this)(0,2) = -sina;
		(*this)(2,0) = sina;
		(*this)(2,2) = cosa;

		return *this;
	}

	const Generic_Matrix<coord> &rotate_z( coord a )
	{
		coord cosa = cos( a );
		coord sina = sin( a );

		idle();

		(*this)(0,0) = cosa;
		(*this)(0,1) = sina;
		(*this)(1,0) = -sina;
		(*this)(1,1) = cosa;

		return *this;
	}

	const Generic_Matrix<coord> &rotate_xyz( coord a, coord b, coord c )
	{	
		coord cosa = cos( a );
		coord sina = sin( a );
		coord cosb = cos( b );
		coord sinb = sin( b );
		coord cosc = cos( c );
		coord sinc = sin( c );

		coord sinasinb = sina*sinb;

		idle();

		(*this)(0,0) = cosc*cosb-sinc*sinasinb;
		(*this)(0,1) = sinc*cosb+cosc*sinasinb;
		(*this)(0,2) = cosa*sinb;

		(*this)(1,0) = -sinc*cosa;
		(*this)(1,1) = cosc*cosa;
		(*this)(1,2) = -sina;

		(*this)(2,0) = -cosc*sinb-sinc*sina*cosb;
		(*this)(2,1) = cosc*sina*cosb-sinc*sinb;
		(*this)(2,2) = cosa*cosb;

		return *this;
	}

	
	const Generic_Matrix<coord> &camera( const Generic_Vector<coord> &rvp, const Generic_Vector<coord> &lap, const coord roll )
	{
		coord co = cos( roll );
		coord si = sin( roll );

		Generic_Vector<coord> vup( co+si, 0.0, co-si );

		Generic_Vector<coord> n = rvp-lap;
		n.normalize();	
		Generic_Vector<coord> u = vup*n;
		u.normalize();
		Generic_Vector<coord> v = n*u;

		idle();
		set_local_x( u );
		set_local_y( v );
		set_local_z( n );
		set_origin( Generic_Vector<coord>(0,0,0)-rvp );
		
		return *this;
	}

	// no extra memory needed
	const Generic_Matrix<coord> &transpose()
	{
		for ( int i = 0; i < 4; i++ )
			for ( int j = 0; j < i+1; j++ )
				;
				//swap<coord>( (*this)(i,j), (*this)(j,i) );
		return *this;
	}

	/*
	 *	U N A R Y   O P E R A T O R S
	 */

	const Generic_Matrix<coord> &operator - ()
	{
		coord *p = matrix;
		for ( int i = 0; i < 16; i++, p++ )
			*p = -*p;
		return *this;
	}

	const Generic_Matrix<coord> &operator ~ ()
	{
		return transpose();
	}
	
	/*
	 *	B I N A R Y   O P E R A T O R S
	 */

	const Generic_Matrix<coord> &operator += ( const Generic_Matrix<coord> &m )
	{
		for ( int i = 0; i < 4; i++ )
			for ( int j = 0; j < i+1; j++ )
				(*this)(i,j) += m(i,j);
		return *this;	
	}

	const Generic_Matrix<coord> &operator -= ( const Generic_Matrix<coord> &m )
	{
		for ( int i = 0; i < 4; i++ )
			for ( int j = 0; j < i+1; j++ )
				(*this)(i,j) -= m(i,j);
		return *this;	
	}

	const Generic_Matrix<coord> &operator *= ( const Generic_Matrix<coord> &m )
	{
		for ( int i = 0; i < 4; i++ )
			for ( int j = 0; j < i+1; j++ )
				(*this)(i,j) = (*this)(i,0)*m(0,j)+
					       (*this)(i,1)*m(1,j)+
					       (*this)(i,2)*m(2,j)+
					       (*this)(i,3)*m(3,j);
		return *this;
	}

	Generic_Matrix<coord> operator + ( const Generic_Matrix<coord> &m )
	{
		Generic_Matrix<coord> tmp = *this;
		return tmp += m;
	}

	Generic_Matrix<coord> operator - ( const Generic_Matrix<coord> &m )
	{
		Generic_Matrix<coord> tmp = *this;
		return tmp -= m;
	}

	Generic_Matrix<coord> operator * ( const Generic_Matrix<coord> &m )
	{
		Generic_Matrix<coord> tmp = *this;
		return tmp *= m;
	}

	Generic_Vector<coord> operator * ( const Generic_Vector<coord> &v )
	{
		return Generic_Vector<coord>(
			(*this)(0,0)*v.x+(*this)(1,0)*v.y+(*this)(2,0)*v.z+(*this)(3,0),
			(*this)(0,1)*v.x+(*this)(1,1)*v.y+(*this)(2,1)*v.z+(*this)(3,1),
			(*this)(0,2)*v.x+(*this)(1,2)*v.y+(*this)(2,2)*v.z+(*this)(3,2)
		);
	}
/*
	(friend) const Generic_Vector<coord> &operator *= ( ... )
*/
	bool operator == ( const Generic_Matrix<coord> &m )
	{	
		for ( int i = 0; i < 4; i++ )
			for ( int j = 0; j < 4; j++ )
				if ( (*this)(i,j) != m(i,j) )
					return false;
		return true;
	}

	bool operator != ( const Generic_Matrix<coord> &m )
	{
		return !(*this == m);
	}

	friend ostream &operator << ( ostream &os, const Generic_Matrix<coord> &m )
	{
		for ( int i = 0; i < 4; i++ )
			for ( int j = 0; j < 4; j++ )
				os << m(i,j) << ((j==3)?'\n':'\t');
		return os;
	}

};

typedef class Generic_Matrix<float> Matrix;

#endif // _MATRIX_H_INCLUDED
