
#include "PCX.h"

/*
 *	ZSoft PCX version 5.0 picture loader (handles only 8-bpp indexed pics) 
 */

//#pragma pack
static struct {	// size is 128 bytes
	char id, version, use_rle, bpp;
	short top_left_x, top_left_y, bot_right_x, bot_right_y;
	short horz_res, vert_res;
	char old_palette[48];
	char reserved;
	char bit_planes;
	short scanline_width;
	short palette_type;
	char filler[58];
} pcx_header;

bool PCX_8bpp::load( const char *filename, bool sht )
{
	ifstream file;
	file.open( filename, ios::binary|ios::in );
	if ( !file )
		return false;
	file.read( &pcx_header, 128 );

	// this loader is definetly not universal :)
	if ( ( pcx_header.id != 0x0a ) || 
	     ( pcx_header.version != 0x05 ) ||
	     ( pcx_header.bpp != 8 ) ||
	     ( pcx_header.use_rle == 0 ) ) {
		file.close();
		return false;
	}

	//
	int width = pcx_header.bot_right_x-pcx_header.top_left_x+1;
	int height = pcx_header.bot_right_y-pcx_header.top_left_y+1;

	pixmap = new char8 [width*height];
	colmap = new int32 [256];

	// unpack run length encoded pixel data 
	char8 *rle_out = pixmap;
	char8 *rle_end = rle_out+width*height;

	while ( rle_out < rle_end ) {
	
		char8 rle_cnt;
		file.get( rle_cnt );

		if ( ( rle_cnt & 0xc0 ) == 0xc0 ) {
			rle_cnt &= ~0xc0;
			char8 rle_pix;
			file.get( rle_pix );
			memset( rle_out, rle_pix, rle_cnt );
			rle_out += rle_cnt;
		} else	
			*rle_out++ = rle_cnt;
	}	

	// skip dummy 0xc0 byte 
	file.seekg( 1, ios::cur );

	// load rgb colormap
	for ( int c = 0; c < 256; c++ ) {	
		char8 rgb[3];
		file.read( rgb, 3 );
		colmap[c] = rgb32( rgb[0], rgb[1], rgb[2] );	
	}

	file.close();

	if ( sht )
		shtab = new Shade_Table( colmap );
	
	return true;
}

bool PCX_8bpp::load( const char *filename, int32 losh, int32 hish )
{
	if ( load( filename, false ) ) {
		shtab = new Shade_Table( colmap, losh, hish );
		return true;
	} else
		return false;
}
