
// Lines, Polylines and Polygons... with clipping or not... yep! yep!
//	-- brioche/aspirine <xdefrang@csi.com>
// WARNING : everything in here is optimized for 320x200 !!!


#ifndef _POLY_H_INCLUDED
#define _POLY_H_INCLUDED

#include <cstdlib>

struct Poly_Point {
	int x, y;
};

extern int clip_minx, clip_maxx, clip_miny, clip_maxy;

// warning: no clipping
void line( int x1, int y1, int x2, int y2, unsigned c, unsigned *buffer );
void polyline( const Poly_Point p[], int num, unsigned c, unsigned *buffer );
void polygon( const Poly_Point p[], int num, unsigned c, unsigned *buffer );

// clipping implemented for these
void sc_line( int x1, int y1, int x2, int y2, unsigned c, unsigned *buffer );
void sc_polyline( const Poly_Point p[], int num, unsigned c, unsigned *buffer );
void sc_polygon( const Poly_Point p[], int num, unsigned c, unsigned *buffer );

//
// inlined shorthand functions for the bloody sake of backward compatibility :)
//

inline void line( const Poly_Point &from, const Poly_Point &to, unsigned c, unsigned *buffer )
{
	line( from.x, from.y, to.x, to.y, c, buffer );
}

inline void polyline( const Poly_Point p[], int num, unsigned *buffer )
{
	polyline( p, num, 0xffffff, buffer );
}

inline void polygon( const Poly_Point p[], int num, unsigned *buffer )
{
	polygon( p, num, 0xffffff, buffer );
}

inline void sc_line( const Poly_Point &from, const Poly_Point &to, unsigned c, unsigned *buffer )
{
	sc_line( from.x, from.y, to.x, to.y, c, buffer );
}

inline void sc_polyline( const Poly_Point p[], int num, unsigned *buffer )
{
	sc_polyline( p, num, 0xffffff, buffer );
}

inline void sc_polygon( const Poly_Point p[], int num, unsigned *buffer )
{
	sc_polygon( p, num, 0xffffff, buffer );
}

#endif _POLY_H_INCLUDED
