
// Computes a shade table according to a given palette 
//	-- brioche/aspirine <xdefrang@csi.com>

#ifndef _SHADETABLE_H_INCLUDED
#define _SHADETABLE_H_INCLUDED

#include <ptc.h>
#include "rgb32.h"

class Shade_Table {
		int32 *table;
		void calc( int32 *, int32, int32 );
public:         
		Shade_Table( Palette &, int32 = 0, int32 = 0xffffff );
		Shade_Table( int32 *, int32 = 0, int32 = 0xffffff );
		~Shade_Table();

		int32 get_color( int32 index, int32 shade ) const {
			return table[((char8)(index)<<8)+(char8)(shade)];
		};

		int32 operator () ( int index, int shade ) const {
			return get_color( index, shade );
		};
};

#endif // _SHADETABLE_H_INCLUDED
