
// interface for tunnel-like effects - brioche/aspirine <xdefrang@csi.com>

#ifndef _TUNNEL_H_INCLUDED
#define _TUNNEL_H_INCLUDED

#include <cmath>
#include <ptc.h>
#include "rgb32.h"

// Tunnel coordinates calculation interface
class Tunnel_Calc {
public:
	virtual void operator () ( float x, float y, int32 &u, int32 &v ) const = 0; 
};

// Standard tunnel
class Std_Tunnel : public Tunnel_Calc {
	float rad;
public:
	Std_Tunnel( float radius );
	void operator () ( float x, float y, int32 &u, int32 &v ) const; 
};

// Flat tunnel
class Flat_Tunnel : public Tunnel_Calc {
	float k;
public:
	Flat_Tunnel( float div );
	void operator () ( float x, float y, int32 &u, int32 &v ) const; 
};

// Weird tunnel
class Weird_Tunnel : public Tunnel_Calc {
	float k;
public:
	Weird_Tunnel( float scale );
	void operator () ( float x, float y, int32 &u, int32 &v ) const; 
};

// Base tunnel interface
class Tunnel_Base {
protected:
	int32 uv_offset;
public:
	void set_u_offset( int32 u ) { uv_offset &= 0xff00; uv_offset |= u&0xff; }
	void set_v_offset( int32 v ) { uv_offset &= 0xff; uv_offset |= (v&0xff)<<8; }
	virtual void draw( int32 *surface, int32 *texture ) = 0;
	virtual void draw_avg( int32 *surface, int32 *texture ) = 0;
};

// Good old 320x200 tunnel
class Tunnel : public Tunnel_Base {
	ushort table[320*200];
public: 
	Tunnel();
	Tunnel( const Tunnel_Calc &calc );
	void mix( Tunnel &t1, Tunnel &t2 );
	void mix2( Tunnel &t1, Tunnel &t2 );
	//void mix( Big_Tunnel &t1, Tunnel &t2 );
	//void mix2( Big_Tunnel &t1, Tunnel &t2 );
	//void mix( Big_Tunnel &t1, Big_Tunnel &t2 );
	//void mix2( Big_Tunnel &t1, Big_Tunnel &t2 );
	void draw( int32 *surface, int32 *texture );
	void draw_avg( int32 *surface, int32 *texture );
};

// Big 640x400 tunnel with 320x200 windowing
class Big_Tunnel : public Tunnel_Base {
	friend class Tunnel;
	ushort table[640*400];
	int32 start_offset;
public: 
	Big_Tunnel();
	Big_Tunnel( const Tunnel_Calc &calc );

	void set_start_offset( int o ) { start_offset = o; };
	void set_start_offset( int x, int y ) { start_offset = y*640+x; };

	void draw( int32 *surface, int32 *texture );
	void draw_avg( int32 *surface, int32 *texture );
};

#endif // _TUNNEL_H_INCLUDED

