#ifndef __3DMATH_H
#define __3DMATH_H

#include "structs.h"

//long ceil(const double f);

/*
void subvectors (vector *v, vector *u);
#pragma aux subvectors parm [esi][edi] modify [8087] = \
     "fld   dword ptr[esi]"\
     "fsub  dword ptr[edi]"\
     "fld   dword ptr[esi+4]"\
     "fsub  dword ptr[edi+4]"\
     "fld   dword ptr[esi+8]"\
     "fsub  dword ptr[edi+8]"\
     "fstp  dword ptr[esi+8]"\
     "fstp  dword ptr[esi+4]"\     
     "fstp  dword ptr[esi]"

void addvectors (vector *v, vector *u);
#pragma aux addvectors parm [esi][edi] modify [8087] = \
     "fld   dword ptr[esi]"\
     "fadd  dword ptr[edi]"\
     "fld   dword ptr[esi+4]"\
     "fadd  dword ptr[edi+4]"\
     "fld   dword ptr[esi+8]"\
     "fadd  dword ptr[edi+8]"\
     "fstp  dword ptr[esi+8]"\
     "fstp  dword ptr[esi+4]"\     
     "fstp  dword ptr[esi]"

void dotproduct (float *r, vector *u, vector *v);
#pragma aux dotproduct parm [edx][esi][edi] modify [8087] = \
     "fld   dword ptr[esi]"\
     "fmul  dword ptr[edi]"\
     "fld   dword ptr[esi+4]"\
     "fmul  dword ptr[edi+4]"\
     "fld   dword ptr[esi+8]"\
     "fmul  dword ptr[edi+8]"\
     "fxch  st(1)"\
     "faddp st(2), st(0)"\
     "faddp st(1), st(0)"\
     "fstp  dword ptr[edx]"

void crossproduct (vector *r, vector *u, vector *v);
#pragma aux crossproduct parm [ebx][edi][esi] modify [8087] = \
     "fld    dword ptr[esi+4]"\
     "fmul   dword ptr[edi+8]"\
     "fld    dword ptr[esi+8]"\
     "fmul   dword ptr[edi]"\
     "fld    dword ptr[esi]"\
     "fmul   dword ptr[edi+4]"\
     "fld    dword ptr[esi+8]"\
     "fmul   dword ptr[edi+4]"\
     "fld    dword ptr[esi]"\
     "fmul   dword ptr[edi+8]"\
     "fld    dword ptr[esi+4]"\
     "fmul   dword ptr[edi]"\
     "fxch   st(2)"\
     "fsubrp st(5), st(0)"\
     "fsubrp st(3), st(0)"\
     "fsubrp st(1), st(0)"\
     "fxch   st(2)"\
     "fstp   dword ptr[ebx]"\
     "fstp   dword ptr[ebx+4]"\
     "fstp   dword ptr[ebx+8]"

// transforme le vecteur r par la matrice en le vecteur s     
void transform (vector *s, vector *r, float *matrix);
#pragma aux transform parm [ebx][esi][edi] modify [8087] = \
     "fld    dword ptr[esi+0]"\
     "fmul   dword ptr[edi+0]"\
     "fld    dword ptr[esi+0]"\
     "fmul   dword ptr[edi+12]"\
     "fld    dword ptr[esi+0]"\
     "fmul   dword ptr[edi+24]"\
     "fld    dword ptr[esi+4]"\
     "fmul   dword ptr[edi+4]"\
     "fld    dword ptr[esi+4]"\
     "fmul   dword ptr[edi+16]"\
     "fld    dword ptr[esi+4]"\
     "fmul   dword ptr[edi+28]"\
     "fxch   st(2)"\
     "faddp  st(5), st(0)"\
     "faddp  st(3), st(0)"\
     "faddp  st(1), st(0)"\
     "fld    dword ptr[esi+8]"\
     "fmul   dword ptr[edi+8]"\
     "fld    dword ptr[esi+8]"\
     "fmul   dword ptr[edi+20]"\
     "fld    dword ptr[esi+8]"\
     "fmul   dword ptr[edi+32]"\
     "fxch   st(2)"\
     "faddp  st(5), st(0)"\
     "faddp  st(3), st(0)"\
     "faddp  st(1), st(0)"\
     "fxch   st(2)"\
     "fxch  st(1)"\
     "fxch  st(2)"\
     "fxch  st(1)"\
     "fstp  dword ptr[ebx+0]"\
     "fstp  dword ptr[ebx+8]"\
     "fstp  dword ptr[ebx+4]"

*/

void subvectors (vector *v, vector *u);
void addvectors (vector *v, vector *u);
void crossproduct (vector *r, vector *u, vector *v);
void dotproduct (float *r, vector *u, vector *v);
void transform (vector *s, vector *r, float *matrix);

void mulvector (vector *v, const float u);

void sqrlength (float *r, const vector v);
void length (float *r, const vector v);
void normalize (vector *v);
void setlength (vector *v, const float longueur);

// multiplie a par b resultat dans r, matrices 3*3
void matmult (float *r, float *a, float *b);

// si la matrice est orthogonale transposee = inverse (3*3)
void transpose (float *matrix, float *source);
void createRotationMatrix(float *matrix, const vector r);

// fonction qui contruit une matrice 3*3 de rotation
// en fonction des vecteurs position et lookat
// rolldegrees = si on tourne la tete
void createViewMatrix(float *matrix, vector position, const vector lookat, const float rolldegrees);

#define lerp(a, b, t) ( a + t * (b - a) )

int search(short *time_track,const int num_keys,const float time);

// on considere les parametres tension bias et continuity comme des constantes
void keys_spline_vector(vector *position,vector *track,short *time_track,const int num_keys,const float time);
void keys_lerp_vector(vector *position,vector *track,short *time_track,const int num_keys,const float time);

void keys_spline_float(float *position,float *track,short *time_track,const int num_keys,const float time);
void keys_lerp_float(float *position,float *track,short *time_track,const int num_keys,const float time);

#endif
