#include "flare32.h"
#include "tinymath.h"
#include "screen.h"

// Return random value between -1 and 1

float frand1d(int x)
{
	int s = 71 * x;
        s = s * 8192 ^ s;
	return 1.0 - ((s*(s*s*15731+789221)+1376312589)& 0x7fffffff)/1073741824.0;
}

// Return bandlimited noise. Each integer value has a different
// random number. Values in-between use linear interpolation.

float Noise1D(float x)
{
	int i=x;
	return frand1d(i) + (frand1d(i+1)-frand1d(i))*(x-i);
}

// Draw the flare

//buffer 32bit/pixel,taille de l'image (L et l),zoom,diametre de l'anneau,epaisseur de l'anneau
void doit(DWORD *buffer,int dimension,float diameter,float rmid,float rwid,float mr, float mg, float mb,float rr, float rg, float rb)
{
    int x, y;

        int dim2=dimension>>1;
        float dx, dy, d, a, v, gaga;
        DWORD r,g,b;
        float ra,ga,ba;

    float linear = 0.03;  // vitesse d'assombrissement en fonction des diametres
    float gauss  = 0.006; // lumierre +/- ponctuelle
    float mix    = 0.50;  // le pas d'assombrissement

    float ring, rmin=rmid - rwid, rmax=rmid + rwid;

	for (y=0; y<dimension; y++)
	{
		dy = dim2 - y;
		for (x=0; x<dimension; x++)
		{
			dx = x - dim2;

			// Get distance from center of flare

			d = fsqrt(dx*dx + dy*dy) * diameter; // 0.5 controls diameter

			// The center of the flare is modelled as a gaussian
			// bump, and the glow around is a simple falloff.
			// Mix and match as you like.
			//
			// If calculating in RGB try making the bump white
			// and the glow red-orange.

			a = fexp(-d*d*gauss)*mix + fexp(-d*linear)*(1-mix);

			// Draw the ring around the flare. An orange-red
			// color is appropriate here as well.
			// Try RGB = {80,20,10} (or was it darker?)

			if (d<rmin || d>rmax)
				ring = 0;
			else
			{
				ring = ffabs(d-rmid)/rwid;
				ring = (1 - ring*ring*(3 - 2*ring))*0.10;
			}

			// a += ring; // separe pour chaque composantes

			// Creates random lines out from the center.
			// v/M_PI*17 controls the number of lines.
			// v*10 sets the noise frequency
			// *2 is the noise modulation

			v = fpatan(dx,dy)+M_PI;
                        gaga=v/M_PI*17 + 1.0 + Noise1D(v*10);
			v = fpow(ffabs((gaga-(int)gaga - 0.5)*2), 5.0);

			// Add lines and fade out over distance.

			a += 0.10*v / (1 + d*0.1);
 
 if (a>1) a=1; // Clip a to maximum value (1)
                      
 ra = mr*(a+ring*rr);
 ga = mg*(a+ring*rg);
 ba = mb*(a+ring*rb);

 r = 255.0 * ra; if (r>255) r=255;
 g = 255.0 * ga; if (g>255) g=255;
 b = 255.0 * ba; if (b>255) b=255;

 buffer[y*dimension+x]=(DWORD)((r<<16)+(g<<8)+b); // RGB 888
		}
                
	}
}


static DWORD putsprite_save_ecx;

// procedure qui affiche un sprite pas de clipping
void putsprite(void *dest, void *src, DWORD taillex, DWORD tailley, DWORD dimtable, DWORD ecran_taille);
#pragma aux putsprite = \
  "push ebp "\
  "sub ebx,ecx" \
  "sub edx,ecx" \
  "mov ebp,eax" \
  "mov [putsprite_save_ecx],ecx" \
  "lcopy_y:" \
  "lcopy_x: mov al,[esi]" \
  "inc esi" \
  "or al,al" \
  "je valeur_0" \
  "mov [edi],al" \
  "valeur_0: inc edi" \
  "dec ecx " \
  "jnz lcopy_x" \
  "dec ebp" \
  "jz fini" \
  "add esi,edx" \
  "add edi,ebx" \
  "mov ecx,[putsprite_save_ecx]" \
  "jmp lcopy_y" \
  "fini:" \
  "pop ebp "\
parm[edi][esi][ecx][eax][edx][ebx]


static DWORD putsprite_32b_save_ecx;

// procedure qui affiche un sprite pas de clipping
void putsprite_32b(void *dest, void *src, DWORD taillex, DWORD tailley, DWORD dimtable, DWORD ecran_taille);
#pragma aux putsprite_32b = \
  "push ebp "\
  "sub ebx,ecx" \
  "sub edx,ecx" \
  "mov ebp,eax" \
  "mov [putsprite_32b_save_ecx],ecx" \
  "lcopy_y:" \
  "lcopy_x: mov eax,[esi]" \
  "add esi,4" \
  "or eax,eax" \
  "je valeur_0" \
  "mov [edi],eax" \
  "valeur_0: add edi,4" \
  "dec ecx " \
  "jnz lcopy_x" \
  "dec ebp" \
  "jz fini" \
  "add esi,edx" \
  "add edi,ebx" \
  "add esi,edx" \
  "add edi,ebx" \
  "mov ecx,[putsprite_32b_save_ecx]" \
  "jmp lcopy_y" \
  "fini:" \
  "pop ebp "\
parm[edi][esi][ecx][eax][edx][ebx]


 void meta_zoom32 (void *ecran,void *MAP,long lx,long ly,long zoom);
 #pragma aux meta_zoom32 "_^" parm [edi][esi][eax][ecx][edx] modify [ebx]

putmeta_clip_zoom(DWORD *dest,DWORD *texture,int x,int y,DWORD diametre)
{
 int lx,ly,xe,ye,begin=0;
 int rayon=diametre>>1;
 int zoom=(256*256)/diametre;

 x-=rayon;
 y-=rayon;

 if (x>=RightClip || y>=BotClip || x<=LeftClip-diametre || y<=TopClip-diametre) return;

 lx=ly=diametre;
 xe=x;
 ye=y;

 if (x<LeftClip)
 {
  lx+=x-LeftClip;
  begin=-(x-LeftClip)*(256.0/diametre);
  xe=LeftClip;
 }
 if (x+diametre>=RightClip) lx-=x+diametre-RightClip;
 if (y<TopClip) 
 {
  ly+=y-TopClip;
  begin-=((int)((y-TopClip)*(256.0/diametre)))<<8;
  ye=TopClip;
 }
 if (y+diametre>=BotClip) ly-=y+diametre-BotClip;

meta_zoom32(dest+xe+ye*WritePageWidth,texture+begin,lx,ly,zoom); //256=normal

}
