#include "morphing.h"
#include "3dmath.h"
#include "normals.h"

void morphing(object *objet, const float time)
{
 register int i;
 register float t;

 vector *meshe1;
 vector *meshe2;

 vertex *vertices=objet->vertices;

if (objet->keys_morphing_times[0]>=time) return;

// calcul du temps -> dichotomique
i=search(objet->keys_morphing_times,objet->num_keys_morphing, time);

// fin du morphing ?
//if(i==objet->num_keys_morphing) return;

--i;
t=time-objet->keys_morphing_times[i];
t/=objet->keys_morphing_times[i+1]-objet->keys_morphing_times[i]; 
// t est compris entre 0 et 1

i*=objet->num_vertices;

meshe1=objet->morph_vertices+i;
meshe2=meshe1+objet->num_vertices;

// on interpole les vertices
for (i=0; i<objet->num_vertices; ++i)
{

 vertices->pos.x = lerp(meshe1->x , meshe2->x, t);
 vertices->pos.y = lerp(meshe1->y , meshe2->y, t);
 vertices->pos.z = lerp(meshe1->z , meshe2->z, t);

 meshe1++;
 meshe2++;
 vertices++; // vertice suivante
}

// on recalcule les normales aux faces et vertices
 buildVert2Polys(objet);
 calcFacesNormal(objet); 
 calcVertsNormal(objet);
}
