/*
 construction des normales aux vertexs et aux faces
*/

#include "normals.h"
#include "3dmath.h"

// construit la table de conversion vertice to polygones pour l'objet
void buildVert2Polys(object *objet)
{
 register int i;
 
  for (i=0; i<objet->num_vertices; i++)
  {
    register int j,n;

    for (j=n=0; j<objet->num_polygons; j++)
    {
      register M3D_polygon *poly=objet->polygons+j;
      register int k;

      for (k=0; k<poly->n; k++)
       if(poly->p[k]==i) {objet->vert2polys[i].p[n]=j; ++n;}
    }
    objet->vert2polys[i].n=n;
  }
}

void calcFacesNormal(object *objet) 
{
  register int i;
  vertex *verts=objet->vertices;
  M3D_polygon *poly=objet->polygons;

  for (i=0; i<objet->num_polygons; i++ )
  {
    vector a,b,c,u,v;
    register int *p=poly[i].p;
    vector *normal=&poly[i].normal;

    a= verts[p[0]].pos;
    b= verts[p[1]].pos;
    c= verts[p[2]].pos;
    u.x=a.x-b.x;    u.y=a.y-b.y;    u.z=a.z-b.z;
    v.x=a.x-c.x;    v.y=a.y-c.y;    v.z=a.z-c.z;

    crossproduct (normal, &u, &v);
    normalize(normal);
  }
}

// utilise le tableau vert2polys
void calcVertsNormal(object *objet)
{
  register int i;
  vertice2polygons *v2p=objet->vert2polys;

  for (i=0; i<objet->num_vertices; i++)
  {
    vector normal;
    register int n;
    register int m=v2p[i].n;
    register int *p=v2p[i].p;
    M3D_polygon *poly=objet->polygons;

    normal.x=normal.y=normal.z=0;
    for (n=0; n<m; ++n)
     addvectors(&normal, &poly[p[n]].normal);

    normalize(&normal);
    objet->vertices[i].normal=normal;
  }
}
